/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.List;
import java.util.Properties;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.jcache.JCacheEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JCacheEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return JCacheEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return JCacheEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "cachingProvider": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCachingProvider((String)JCacheEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cacheConfiguration": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheConfiguration((Configuration)JCacheEndpointConfigurer.property((CamelContext)camelContext, Configuration.class, (Object)value));
                return true;
            }
            case "cacheConfigurationProperties": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheConfigurationProperties((Properties)JCacheEndpointConfigurer.property((CamelContext)camelContext, Properties.class, (Object)value));
                return true;
            }
            case "configurationUri": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setConfigurationUri((String)JCacheEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cacheLoaderFactory": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheLoaderFactory((Factory<CacheLoader>)((Factory)JCacheEndpointConfigurer.property((CamelContext)camelContext, Factory.class, (Object)value)));
                return true;
            }
            case "cacheWriterFactory": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheWriterFactory((Factory<CacheWriter>)((Factory)JCacheEndpointConfigurer.property((CamelContext)camelContext, Factory.class, (Object)value)));
                return true;
            }
            case "expiryPolicyFactory": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setExpiryPolicyFactory((Factory<ExpiryPolicy>)((Factory)JCacheEndpointConfigurer.property((CamelContext)camelContext, Factory.class, (Object)value)));
                return true;
            }
            case "readThrough": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setReadThrough((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "writeThrough": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setWriteThrough((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "storeByValue": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setStoreByValue((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "statisticsEnabled": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setStatisticsEnabled((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "managementEnabled": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setManagementEnabled((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "filteredEvents": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setFilteredEvents((List)JCacheEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "eventFilters": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setEventFilters((List)JCacheEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "oldValueRequired": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setOldValueRequired((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setSynchronous((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "action": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setAction((String)JCacheEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "createCacheIfNotExists": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCreateCacheIfNotExists((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lookupProviders": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setLookupProviders((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((JCacheEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((JCacheEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((JCacheEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)JCacheEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((JCacheEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)JCacheEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((JCacheEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "cachingprovider": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCachingProvider((String)JCacheEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cacheconfiguration": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheConfiguration((Configuration)JCacheEndpointConfigurer.property((CamelContext)camelContext, Configuration.class, (Object)value));
                return true;
            }
            case "cacheconfigurationproperties": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheConfigurationProperties((Properties)JCacheEndpointConfigurer.property((CamelContext)camelContext, Properties.class, (Object)value));
                return true;
            }
            case "configurationuri": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setConfigurationUri((String)JCacheEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cacheloaderfactory": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheLoaderFactory((Factory<CacheLoader>)((Factory)JCacheEndpointConfigurer.property((CamelContext)camelContext, Factory.class, (Object)value)));
                return true;
            }
            case "cachewriterfactory": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCacheWriterFactory((Factory<CacheWriter>)((Factory)JCacheEndpointConfigurer.property((CamelContext)camelContext, Factory.class, (Object)value)));
                return true;
            }
            case "expirypolicyfactory": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setExpiryPolicyFactory((Factory<ExpiryPolicy>)((Factory)JCacheEndpointConfigurer.property((CamelContext)camelContext, Factory.class, (Object)value)));
                return true;
            }
            case "readthrough": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setReadThrough((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "writethrough": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setWriteThrough((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "storebyvalue": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setStoreByValue((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "statisticsenabled": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setStatisticsEnabled((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "managementenabled": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setManagementEnabled((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "filteredevents": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setFilteredEvents((List)JCacheEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "eventfilters": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setEventFilters((List)JCacheEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "oldvaluerequired": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setOldValueRequired((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setSynchronous((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "action": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setAction((String)JCacheEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "createcacheifnotexists": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setCreateCacheIfNotExists((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lookupproviders": {
                ((JCacheEndpoint)((Object)endpoint)).getConfiguration().setLookupProviders((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((JCacheEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((JCacheEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((JCacheEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)JCacheEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((JCacheEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)JCacheEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((JCacheEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)JCacheEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

