/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.Map;
import java.util.Properties;
import javax.cache.configuration.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="jcache")
public class JCacheComponent
extends DefaultComponent {
    private String cachingProvider;
    private Configuration cacheConfiguration;
    private Properties cacheConfigurationProperties;
    private String configurationUri;

    public JCacheComponent() {
    }

    public JCacheComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String cacheName = remaining;
        JCacheConfiguration configuration = new JCacheConfiguration(this.getCamelContext(), cacheName);
        configuration.setCachingProvider(this.cachingProvider);
        configuration.setCacheConfiguration(this.cacheConfiguration);
        configuration.setCacheConfigurationProperties(this.cacheConfigurationProperties);
        configuration.setConfigurationUri(this.configurationUri);
        this.setProperties(configuration, parameters);
        return new JCacheEndpoint(uri, this, configuration);
    }

    public String getCachingProvider() {
        return this.cachingProvider;
    }

    public void setCachingProvider(String cachingProvider) {
        this.cachingProvider = cachingProvider;
    }

    public Configuration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void setCacheConfiguration(Configuration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public Properties getCacheConfigurationProperties() {
        return this.cacheConfigurationProperties;
    }

    public void setCacheConfigurationProperties(Properties cacheConfigurationProperties) {
        this.cacheConfigurationProperties = cacheConfigurationProperties;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }
}

