/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob.springboot;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobType;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.component.azure-blob")
public class BlobServiceComponentConfiguration
extends ComponentConfigurationPropertiesCommon {
    private Boolean enabled;
    private BlobServiceConfigurationNestedConfiguration configuration;
    private Boolean basicPropertyBinding = false;
    private Boolean lazyStartProducer = false;
    private Boolean bridgeErrorHandler = false;

    public BlobServiceConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobServiceConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getBasicPropertyBinding() {
        return this.basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public Boolean getLazyStartProducer() {
        return this.lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public static class BlobServiceConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = BlobServiceConfiguration.class;
        private BlobServiceOperations operation = BlobServiceOperations.listBlobs;
        private String containerName;
        private String blobName;
        private BlobType blobType = BlobType.blockblob;
        private Integer streamWriteSize;
        private Integer streamReadSize;
        private Map blobMetadata;
        private CloudBlob azureBlobClient;
        private Boolean closeStreamAfterWrite = true;
        private Boolean closeStreamAfterRead = true;
        private String fileDir;
        private Long blobOffset = 0L;
        private Long dataLength;
        private String blobPrefix;
        private Boolean publicForRead = false;
        private Boolean useFlatListing = true;
        private String accountName;
        private StorageCredentials credentials;

        public BlobServiceOperations getOperation() {
            return this.operation;
        }

        public void setOperation(BlobServiceOperations operation) {
            this.operation = operation;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public String getBlobName() {
            return this.blobName;
        }

        public void setBlobName(String blobName) {
            this.blobName = blobName;
        }

        public BlobType getBlobType() {
            return this.blobType;
        }

        public void setBlobType(BlobType blobType) {
            this.blobType = blobType;
        }

        public Integer getStreamWriteSize() {
            return this.streamWriteSize;
        }

        public void setStreamWriteSize(Integer streamWriteSize) {
            this.streamWriteSize = streamWriteSize;
        }

        public Integer getStreamReadSize() {
            return this.streamReadSize;
        }

        public void setStreamReadSize(Integer streamReadSize) {
            this.streamReadSize = streamReadSize;
        }

        public Map getBlobMetadata() {
            return this.blobMetadata;
        }

        public void setBlobMetadata(Map blobMetadata) {
            this.blobMetadata = blobMetadata;
        }

        public CloudBlob getAzureBlobClient() {
            return this.azureBlobClient;
        }

        public void setAzureBlobClient(CloudBlob azureBlobClient) {
            this.azureBlobClient = azureBlobClient;
        }

        public Boolean getCloseStreamAfterWrite() {
            return this.closeStreamAfterWrite;
        }

        public void setCloseStreamAfterWrite(Boolean closeStreamAfterWrite) {
            this.closeStreamAfterWrite = closeStreamAfterWrite;
        }

        public Boolean getCloseStreamAfterRead() {
            return this.closeStreamAfterRead;
        }

        public void setCloseStreamAfterRead(Boolean closeStreamAfterRead) {
            this.closeStreamAfterRead = closeStreamAfterRead;
        }

        public String getFileDir() {
            return this.fileDir;
        }

        public void setFileDir(String fileDir) {
            this.fileDir = fileDir;
        }

        public Long getBlobOffset() {
            return this.blobOffset;
        }

        public void setBlobOffset(Long blobOffset) {
            this.blobOffset = blobOffset;
        }

        public Long getDataLength() {
            return this.dataLength;
        }

        public void setDataLength(Long dataLength) {
            this.dataLength = dataLength;
        }

        public String getBlobPrefix() {
            return this.blobPrefix;
        }

        public void setBlobPrefix(String blobPrefix) {
            this.blobPrefix = blobPrefix;
        }

        public Boolean getPublicForRead() {
            return this.publicForRead;
        }

        public void setPublicForRead(Boolean publicForRead) {
            this.publicForRead = publicForRead;
        }

        public Boolean getUseFlatListing() {
            return this.useFlatListing;
        }

        public void setUseFlatListing(Boolean useFlatListing) {
            this.useFlatListing = useFlatListing;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public StorageCredentials getCredentials() {
            return this.credentials;
        }

        public void setCredentials(StorageCredentials credentials) {
            this.credentials = credentials;
        }
    }
}

