/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverters;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.core.xml.AbstractCamelEndpointFactoryBean;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.core.xml.AbstractCamelRedeliveryPolicyFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderFunctionDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.core.xml.PatternBasedPackageScanFilter;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckService;
import org.apache.camel.impl.engine.DefaultManagementStrategy;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.GlobalOptionsDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RestContextRefDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestContainer;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformersDefinition;
import org.apache.camel.model.validator.ValidatorsDefinition;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.runtimecatalog.JSonSchemaResolver;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelContextFactoryBean<T extends ModelCamelContext>
extends IdentifiedType
implements RouteContainer,
RestContainer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelContextFactoryBean.class);
    @XmlTransient
    private List<RoutesBuilder> builders = new ArrayList<RoutesBuilder>();
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart;
    @XmlTransient
    private final AtomicBoolean routesSetupDone = new AtomicBoolean();

    public AbstractCamelContextFactoryBean() {
        this.contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();
    }

    public T getObject() throws Exception {
        return this.getContext();
    }

    public abstract Class<T> getObjectType();

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    /*
     * WARNING - void declaration
     */
    public void afterPropertiesSet() throws Exception {
        Map logListeners;
        UuidGenerator uuidGenerator;
        RouteController routeController;
        HealthCheckService healthCheckService;
        HealthCheckRegistry healthCheckRegistry;
        Map map;
        Map map2;
        Map map3;
        Map lifecycleStrategies;
        Map map4;
        ShutdownStrategy shutdownStrategy;
        Map map5;
        Map eventNotifiers;
        Map typeConverters;
        JSonSchemaResolver jsonSchemaResolver;
        HeadersMapFactory headersMapFactory;
        RuntimeEndpointRegistry runtimeEndpointRegistry;
        UnitOfWorkFactory unitOfWorkFactory;
        EventFactory eventFactory;
        ManagementObjectNameStrategy managementObjectNameStrategy;
        ManagementStrategy managementStrategy;
        AsyncProcessorAwaitManager asyncProcessorAwaitManager;
        InflightRepository inflightRepository;
        org.apache.camel.component.properties.PropertiesComponent pc;
        TypeConverterRegistry tcr;
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)this.getId())) {
            throw new IllegalArgumentException("Id must be set");
        }
        PackageScanClassResolver packageResolver = this.getBeanForType(PackageScanClassResolver.class);
        if (packageResolver != null) {
            LOG.info("Using custom PackageScanClassResolver: {}", (Object)packageResolver);
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setPackageScanClassResolver(packageResolver);
        }
        if ((tcr = this.getBeanForType(TypeConverterRegistry.class)) != null) {
            LOG.info("Using custom TypeConverterRegistry: {}", (Object)tcr);
            this.getContext().setTypeConverterRegistry(tcr);
        }
        if ((pc = this.getBeanForType(org.apache.camel.component.properties.PropertiesComponent.class)) != null) {
            LOG.debug("Using PropertiesComponent: {}", (Object)pc);
            this.getContext().setPropertiesComponent((PropertiesComponent)pc);
        }
        HashMap mergedOptions = new HashMap();
        if (this.getGlobalOptions() != null) {
            mergedOptions.putAll(this.getGlobalOptions().asMap());
        }
        if (!mergedOptions.isEmpty()) {
            this.getContext().setGlobalOptions(mergedOptions);
        }
        this.initCustomRegistry(this.getContext());
        this.initPropertyPlaceholder();
        this.initJMXAgent();
        this.setupCustomServices();
        BacklogTracer backlogTracer = this.getBeanForType(BacklogTracer.class);
        if (backlogTracer != null) {
            LOG.info("Using custom BacklogTracer: {}", (Object)backlogTracer);
            this.getContext().addService((Object)backlogTracer);
        }
        if ((inflightRepository = this.getBeanForType(InflightRepository.class)) != null) {
            LOG.info("Using custom InflightRepository: {}", (Object)inflightRepository);
            this.getContext().setInflightRepository(inflightRepository);
        }
        if ((asyncProcessorAwaitManager = this.getBeanForType(AsyncProcessorAwaitManager.class)) != null) {
            LOG.info("Using custom AsyncProcessorAwaitManager: {}", (Object)asyncProcessorAwaitManager);
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setAsyncProcessorAwaitManager(asyncProcessorAwaitManager);
        }
        if ((managementStrategy = this.getBeanForType(ManagementStrategy.class)) != null) {
            LOG.info("Using custom ManagementStrategy: {}", (Object)managementStrategy);
            this.getContext().setManagementStrategy(managementStrategy);
        }
        if ((managementObjectNameStrategy = this.getBeanForType(ManagementObjectNameStrategy.class)) != null) {
            LOG.info("Using custom ManagementObjectNameStrategy: {}", (Object)managementObjectNameStrategy);
            this.getContext().getManagementStrategy().setManagementObjectNameStrategy(managementObjectNameStrategy);
        }
        if ((eventFactory = this.getBeanForType(EventFactory.class)) != null) {
            LOG.info("Using custom EventFactory: {}", (Object)eventFactory);
            this.getContext().getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((unitOfWorkFactory = this.getBeanForType(UnitOfWorkFactory.class)) != null) {
            LOG.info("Using custom UnitOfWorkFactory: {}", (Object)unitOfWorkFactory);
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setUnitOfWorkFactory(unitOfWorkFactory);
        }
        if ((runtimeEndpointRegistry = this.getBeanForType(RuntimeEndpointRegistry.class)) != null) {
            LOG.info("Using custom RuntimeEndpointRegistry: {}", (Object)runtimeEndpointRegistry);
            this.getContext().setRuntimeEndpointRegistry(runtimeEndpointRegistry);
        }
        if ((headersMapFactory = this.getBeanForType(HeadersMapFactory.class)) != null) {
            LOG.info("Using custom HeadersMapFactory: {}", (Object)headersMapFactory);
            this.getContext().setHeadersMapFactory(headersMapFactory);
        }
        if ((jsonSchemaResolver = this.getBeanForType(JSonSchemaResolver.class)) != null) {
            LOG.info("Using custom JSonSchemaResolver: {}", (Object)jsonSchemaResolver);
            ((RuntimeCamelCatalog)this.getContext().getExtension(RuntimeCamelCatalog.class)).setJSonSchemaResolver(jsonSchemaResolver);
        }
        if ((typeConverters = this.getContext().getRegistry().findByTypeWithName(TypeConverters.class)) != null && !typeConverters.isEmpty()) {
            for (Map.Entry entry : typeConverters.entrySet()) {
                TypeConverters typeConverters2 = (TypeConverters)entry.getValue();
                LOG.info("Adding custom TypeConverters with id: {} and implementation: {}", entry.getKey(), (Object)typeConverters2);
                this.getContext().getTypeConverterRegistry().addTypeConverters(typeConverters2);
            }
        }
        if ((eventNotifiers = this.getContext().getRegistry().findByTypeWithName(EventNotifier.class)) != null && !eventNotifiers.isEmpty()) {
            for (Map.Entry entry : eventNotifiers.entrySet()) {
                EventNotifier eventNotifier = (EventNotifier)entry.getValue();
                if (this.getContext().getManagementStrategy().getEventNotifiers().contains(eventNotifier)) continue;
                LOG.info("Using custom EventNotifier with id: {} and implementation: {}", entry.getKey(), (Object)eventNotifier);
                this.getContext().getManagementStrategy().addEventNotifier(eventNotifier);
            }
        }
        if ((map5 = this.getContext().getRegistry().findByTypeWithName(EndpointStrategy.class)) != null && !map5.isEmpty()) {
            for (Map.Entry entry : map5.entrySet()) {
                EndpointStrategy strategy = (EndpointStrategy)entry.getValue();
                LOG.info("Using custom EndpointStrategy with id: {} and implementation: {}", entry.getKey(), (Object)strategy);
                ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).registerEndpointCallback(strategy);
            }
        }
        if ((shutdownStrategy = this.getBeanForType(ShutdownStrategy.class)) != null) {
            LOG.info("Using custom ShutdownStrategy: {}", (Object)shutdownStrategy);
            this.getContext().setShutdownStrategy(shutdownStrategy);
        }
        if ((map4 = this.getContext().getRegistry().findByTypeWithName(InterceptStrategy.class)) != null && !map4.isEmpty()) {
            for (Map.Entry entry : map4.entrySet()) {
                InterceptStrategy interceptStrategy = (InterceptStrategy)entry.getValue();
                if (((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).getInterceptStrategies().contains(interceptStrategy)) continue;
                LOG.info("Using custom InterceptStrategy with id: {} and implementation: {}", entry.getKey(), (Object)interceptStrategy);
                ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).addInterceptStrategy(interceptStrategy);
            }
        }
        if ((lifecycleStrategies = this.getContext().getRegistry().findByTypeWithName(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (Map.Entry entry : lifecycleStrategies.entrySet()) {
                LifecycleStrategy lifecycleStrategy = (LifecycleStrategy)entry.getValue();
                if (this.getContext().getLifecycleStrategies().contains(lifecycleStrategy)) continue;
                LOG.info("Using custom LifecycleStrategy with id: {} and implementation: {}", entry.getKey(), (Object)lifecycleStrategy);
                this.getContext().addLifecycleStrategy(lifecycleStrategy);
            }
        }
        if ((map3 = this.getContext().getRegistry().findByTypeWithName(CamelClusterService.class)) != null && !map3.isEmpty()) {
            for (Map.Entry entry : map3.entrySet()) {
                CamelClusterService camelClusterService = (CamelClusterService)entry.getValue();
                LOG.info("Using CamelClusterService with id: {} and implementation: {}", (Object)camelClusterService.getId(), (Object)camelClusterService);
                this.getContext().addService((Object)camelClusterService);
            }
        }
        if ((map2 = this.getContext().getRegistry().findByTypeWithName(ServiceRegistry.class)) != null && !map2.isEmpty()) {
            for (Map.Entry entry : map2.entrySet()) {
                ServiceRegistry serviceRegistry = (ServiceRegistry)entry.getValue();
                if (serviceRegistry.getId() == null) {
                    serviceRegistry.setId(this.getContext().getUuidGenerator().generateUuid());
                }
                LOG.info("Using ServiceRegistry with id: {} and implementation: {}", (Object)serviceRegistry.getId(), (Object)serviceRegistry);
                this.getContext().addService((Object)serviceRegistry);
            }
        }
        if ((map = this.getContext().getRegistry().findByTypeWithName(RoutePolicyFactory.class)) != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                RoutePolicyFactory factory = (RoutePolicyFactory)entry.getValue();
                LOG.info("Using custom RoutePolicyFactory with id: {} and implementation: {}", entry.getKey(), (Object)factory);
                this.getContext().addRoutePolicyFactory(factory);
            }
        }
        if ((healthCheckRegistry = this.getBeanForType(HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext(this.getContext());
            LOG.info("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            this.getContext().setExtension(HealthCheckRegistry.class, (Object)healthCheckRegistry);
        } else {
            HealthCheckRegistry healthCheckRegistry2 = HealthCheckRegistry.get(this.getContext());
        }
        Set set = this.getContext().getRegistry().findByType(HealthCheckRepository.class);
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)set)) {
            for (HealthCheckRepository repository : set) {
                void var24_55;
                var24_55.addRepository(repository);
            }
        }
        if ((healthCheckService = this.getBeanForType(HealthCheckService.class)) != null) {
            LOG.info("Using HealthCheckService: {}", (Object)healthCheckService);
            this.getContext().addService((Object)healthCheckService);
        }
        if ((routeController = this.getBeanForType(RouteController.class)) != null) {
            LOG.info("Using RouteController: {}", (Object)routeController);
            this.getContext().setRouteController(routeController);
        }
        if ((uuidGenerator = this.getBeanForType(UuidGenerator.class)) != null) {
            LOG.info("Using custom UuidGenerator: {}", (Object)uuidGenerator);
            this.getContext().setUuidGenerator(uuidGenerator);
        }
        if ((logListeners = this.getContext().getRegistry().findByTypeWithName(LogListener.class)) != null && !logListeners.isEmpty()) {
            for (Map.Entry entry : logListeners.entrySet()) {
                LogListener logListener = (LogListener)entry.getValue();
                if (((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).getLogListeners().contains(logListener)) continue;
                LOG.info("Using custom LogListener with id: {} and implementation: {}", entry.getKey(), (Object)logListener);
                ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).addLogListener(logListener);
            }
        }
        this.initThreadPoolProfiles(this.getContext());
        this.initBeanPostProcessor(this.getContext());
        this.initCamelContext(this.getContext());
        this.initStreamCachingStrategy();
        this.getContext().init();
    }

    protected void setupRoutes() throws Exception {
        if (this.routesSetupDone.compareAndSet(false, true)) {
            LOG.debug("Setting up routes");
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setupRoutes(false);
            this.initRouteRefs();
            this.initRestRefs();
            this.getContext().addRestDefinitions(this.getRests(), false);
            for (RestConfiguration config : this.getContext().getRestConfigurations()) {
                if (config.getApiContextPath() == null) continue;
                boolean hasRestApi = false;
                for (RouteDefinition route : this.getContext().getRouteDefinitions()) {
                    FromDefinition from = route.getInput();
                    if (from.getUri() == null || !from.getUri().startsWith("rest-api:")) continue;
                    hasRestApi = true;
                }
                if (hasRestApi) continue;
                RouteDefinition route = RestDefinition.asRouteApiDefinition(this.getContext(), (RestConfiguration)config);
                LOG.debug("Adding routeId: {} as rest-api route", (Object)route.getId());
                this.getRoutes().add(route);
            }
            for (RestDefinition rest : this.getContext().getRestDefinitions()) {
                rest.asRouteDefinition(this.getContext()).forEach(r -> this.getRoutes().add((RouteDefinition)r));
            }
            this.prepareRoutes();
            this.getContext().addRouteDefinitions(this.getRoutes());
            LOG.debug("Found JAXB created routes: {}", this.getRoutes());
            this.findRouteBuilders();
            this.installRoutes();
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setupRoutes(true);
        }
    }

    private void prepareRoutes() {
        for (RouteDefinition route : this.getRoutes()) {
            RouteDefinitionHelper.sanityCheckRoute((RouteDefinition)route);
            RouteDefinitionHelper.prepareRoute(this.getContext(), (RouteDefinition)route, this.getOnExceptions(), this.getIntercepts(), this.getInterceptFroms(), this.getInterceptSendToEndpoints(), this.getOnCompletions());
            route.markPrepared();
        }
    }

    protected abstract void initCustomRegistry(T var1);

    protected void initJMXAgent() throws Exception {
        CamelJMXAgentDefinition camelJMXAgent = this.getCamelJMXAgent();
        boolean disabled = false;
        if (camelJMXAgent != null) {
            boolean bl = disabled = camelJMXAgent.getDisabled() != null && CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getDisabled()) != false;
        }
        if (disabled) {
            LOG.info("JMXAgent disabled");
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy());
        } else if (camelJMXAgent != null) {
            LOG.info("JMXAgent enabled: {}", (Object)camelJMXAgent);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (camelJMXAgent.getConnectorPort() != null) {
                properties.put("connectorPort", CamelContextHelper.parseInteger(this.getContext(), (String)camelJMXAgent.getConnectorPort()));
            }
            if (camelJMXAgent.getCreateConnector() != null) {
                properties.put("createConnector", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getCreateConnector()));
            }
            if (camelJMXAgent.getMbeanObjectDomainName() != null) {
                properties.put("mbeanObjectDomainName", CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getMbeanObjectDomainName()));
            }
            if (camelJMXAgent.getRegistryPort() != null) {
                properties.put("registryPort", CamelContextHelper.parseInteger(this.getContext(), (String)camelJMXAgent.getRegistryPort()));
            }
            if (camelJMXAgent.getServiceUrlPath() != null) {
                properties.put("serviceUrlPath", CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getServiceUrlPath()));
            }
            if (camelJMXAgent.getUsePlatformMBeanServer() != null) {
                properties.put("usePlatformMBeanServer", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getUsePlatformMBeanServer()));
            }
            if (camelJMXAgent.getOnlyRegisterProcessorWithCustomId() != null) {
                properties.put("onlyRegisterProcessorWithCustomId", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getOnlyRegisterProcessorWithCustomId()));
            }
            if (camelJMXAgent.getRegisterAlways() != null) {
                properties.put("registerAlways", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getRegisterAlways()));
            }
            if (camelJMXAgent.getRegisterNewRoutes() != null) {
                properties.put("registerNewRoutes", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getRegisterNewRoutes()));
            }
            if (camelJMXAgent.getIncludeHostName() != null) {
                properties.put("includeHostName", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getIncludeHostName()));
            }
            if (camelJMXAgent.getUseHostIPAddress() != null) {
                properties.put("useHostIPAddress", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getUseHostIPAddress()));
            }
            if (camelJMXAgent.getMask() != null) {
                properties.put("mask", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getMask()));
            }
            if (camelJMXAgent.getLoadStatisticsEnabled() != null) {
                properties.put("loadStatisticsEnabled", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getLoadStatisticsEnabled()));
            }
            if (camelJMXAgent.getEndpointRuntimeStatisticsEnabled() != null) {
                properties.put("endpointRuntimeStatisticsEnabled", CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getEndpointRuntimeStatisticsEnabled()));
            }
            if (camelJMXAgent.getStatisticsLevel() != null) {
                String level = CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getStatisticsLevel());
                ManagementStatisticsLevel msLevel = (ManagementStatisticsLevel)this.getContext().getTypeConverter().mandatoryConvertTo(ManagementStatisticsLevel.class, (Object)level);
                properties.put("statisticsLevel", msLevel);
            }
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setupManagement(properties);
        }
    }

    protected void initStreamCachingStrategy() throws Exception {
        String spoolRules;
        Boolean anySpoolRules;
        Boolean statisticsEnabled;
        Boolean remove;
        String spoolCipher;
        String limit;
        Integer spoolUsedHeap;
        Long spoolThreshold;
        String spoolDirectory;
        CamelStreamCachingStrategyDefinition streamCaching = this.getCamelStreamCachingStrategy();
        if (streamCaching == null) {
            return;
        }
        Boolean enabled = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getEnabled());
        if (enabled != null) {
            this.getContext().getStreamCachingStrategy().setEnabled(enabled.booleanValue());
        }
        if ((spoolDirectory = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolDirectory())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolDirectory(spoolDirectory);
        }
        if ((spoolThreshold = CamelContextHelper.parseLong(this.getContext(), (String)streamCaching.getSpoolThreshold())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolThreshold(spoolThreshold.longValue());
        }
        if ((spoolUsedHeap = CamelContextHelper.parseInteger(this.getContext(), (String)streamCaching.getSpoolUsedHeapMemoryThreshold())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(spoolUsedHeap.intValue());
        }
        if ((limit = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolUsedHeapMemoryLimit())) != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit ul = (StreamCachingStrategy.SpoolUsedHeapMemoryLimit)CamelContextHelper.mandatoryConvertTo(this.getContext(), StreamCachingStrategy.SpoolUsedHeapMemoryLimit.class, (Object)limit);
            this.getContext().getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(ul);
        }
        if ((spoolCipher = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolCipher())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolCipher(spoolCipher);
        }
        if ((remove = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getRemoveSpoolDirectoryWhenStopping())) != null) {
            this.getContext().getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(remove.booleanValue());
        }
        if ((statisticsEnabled = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getStatisticsEnabled())) != null) {
            this.getContext().getStreamCachingStrategy().getStatistics().setStatisticsEnabled(statisticsEnabled.booleanValue());
        }
        if ((anySpoolRules = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getAnySpoolRules())) != null) {
            this.getContext().getStreamCachingStrategy().setAnySpoolRules(anySpoolRules.booleanValue());
        }
        if ((spoolRules = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolRules())) != null) {
            for (String name : ObjectHelper.createIterable((String)spoolRules)) {
                StreamCachingStrategy.SpoolRule rule = (StreamCachingStrategy.SpoolRule)this.getContext().getRegistry().lookupByNameAndType(name, StreamCachingStrategy.SpoolRule.class);
                if (rule == null) continue;
                this.getContext().getStreamCachingStrategy().addSpoolRule(rule);
            }
        }
    }

    protected void initPropertyPlaceholder() throws Exception {
        if (this.getCamelPropertyPlaceholder() != null) {
            CamelPropertyPlaceholderDefinition def = this.getCamelPropertyPlaceholder();
            ArrayList locations = new ArrayList();
            if (def.getLocation() != null) {
                ObjectHelper.createIterable((String)def.getLocation()).forEach(location -> locations.add(new PropertiesLocation(location)));
            }
            if (def.getLocations() != null) {
                def.getLocations().forEach(definition -> locations.add(definition.toLocation()));
            }
            org.apache.camel.component.properties.PropertiesComponent pc = new org.apache.camel.component.properties.PropertiesComponent();
            pc.setLocations(locations);
            pc.setEncoding(def.getEncoding());
            if (def.isIgnoreMissingLocation() != null) {
                pc.setIgnoreMissingLocation(def.isIgnoreMissingLocation().booleanValue());
            }
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)def.getPropertiesParserRef())) {
                PropertiesParser parser = (PropertiesParser)CamelContextHelper.mandatoryLookup(this.getContext(), (String)def.getPropertiesParserRef(), PropertiesParser.class);
                pc.setPropertiesParser(parser);
            }
            if (def.getDefaultFallbackEnabled() != null) {
                pc.setDefaultFallbackEnabled(def.getDefaultFallbackEnabled().booleanValue());
            }
            if (def.getFunctions() != null && !def.getFunctions().isEmpty()) {
                for (CamelPropertyPlaceholderFunctionDefinition function : def.getFunctions()) {
                    String ref = function.getRef();
                    PropertiesFunction pf = (PropertiesFunction)CamelContextHelper.mandatoryLookup(this.getContext(), (String)ref, PropertiesFunction.class);
                    pc.addFunction(pf);
                }
            }
            this.getContext().setPropertiesComponent((PropertiesComponent)pc);
        }
    }

    protected void initRouteRefs() throws Exception {
        if (this.getRouteRefs() != null) {
            for (RouteContextRefDefinition ref : this.getRouteRefs()) {
                List defs = ref.lookupRoutes(this.getContext());
                for (RouteDefinition def : defs) {
                    LOG.debug("Adding route from {} -> {}", (Object)ref, (Object)def);
                    this.getRoutes().add(0, def);
                }
            }
        }
    }

    protected void initRestRefs() throws Exception {
        if (this.getRestRefs() != null) {
            for (RestContextRefDefinition ref : this.getRestRefs()) {
                List defs = ref.lookupRests(this.getContext());
                for (RestDefinition def : defs) {
                    LOG.debug("Adding rest from {} -> {}", (Object)ref, (Object)def);
                    this.getRests().add(0, def);
                }
            }
        }
    }

    protected abstract <S> S getBeanForType(Class<S> var1);

    public void destroy() throws Exception {
        this.routesSetupDone.set(false);
        this.getContext().stop();
    }

    public T getContext() {
        return this.getContext(true);
    }

    public abstract T getContext(boolean var1);

    public abstract List<RouteDefinition> getRoutes();

    public abstract List<RestDefinition> getRests();

    public abstract RestConfigurationDefinition getRestConfiguration();

    public abstract List<? extends AbstractCamelEndpointFactoryBean> getEndpoints();

    public abstract List<? extends AbstractCamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies();

    public abstract List<InterceptDefinition> getIntercepts();

    public abstract List<InterceptFromDefinition> getInterceptFroms();

    public abstract List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints();

    public abstract GlobalOptionsDefinition getGlobalOptions();

    public abstract String[] getPackages();

    public abstract PackageScanDefinition getPackageScan();

    public abstract void setPackageScan(PackageScanDefinition var1);

    public abstract ContextScanDefinition getContextScan();

    public abstract void setContextScan(ContextScanDefinition var1);

    public abstract CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder();

    public abstract String getTrace();

    public abstract String getTracePattern();

    public abstract String getMessageHistory();

    public abstract String getLogMask();

    public abstract String getLogExhaustedMessageBody();

    public abstract String getStreamCache();

    public abstract String getDelayer();

    public abstract String getAutoStartup();

    public abstract String getUseMDCLogging();

    public abstract String getMDCLoggingKeysPattern();

    public abstract String getUseDataType();

    public abstract String getUseBreadcrumb();

    public abstract String getAllowUseOriginalMessage();

    public abstract String getRuntimeEndpointRegistryEnabled();

    public abstract String getManagementNamePattern();

    public abstract String getThreadNamePattern();

    public abstract Boolean getLoadTypeConverters();

    public abstract Boolean getTypeConverterStatisticsEnabled();

    public abstract LoggingLevel getTypeConverterExistsLoggingLevel();

    public abstract TypeConverterExists getTypeConverterExists();

    public abstract CamelJMXAgentDefinition getCamelJMXAgent();

    public abstract CamelStreamCachingStrategyDefinition getCamelStreamCachingStrategy();

    public abstract List<RouteBuilderDefinition> getBuilderRefs();

    public abstract List<RouteContextRefDefinition> getRouteRefs();

    public abstract List<RestContextRefDefinition> getRestRefs();

    public abstract String getErrorHandlerRef();

    public abstract DataFormatsDefinition getDataFormats();

    public abstract TransformersDefinition getTransformers();

    public abstract ValidatorsDefinition getValidators();

    public abstract List<OnExceptionDefinition> getOnExceptions();

    public abstract List<OnCompletionDefinition> getOnCompletions();

    public abstract ShutdownRoute getShutdownRoute();

    public abstract ShutdownRunningTask getShutdownRunningTask();

    public abstract List<ThreadPoolProfileDefinition> getThreadPoolProfiles();

    public abstract String getDependsOn();

    public abstract List<AbstractCamelFactoryBean<?>> getBeansFactory();

    public abstract List<?> getBeans();

    public abstract ServiceCallConfigurationDefinition getDefaultServiceCallConfiguration();

    public abstract List<ServiceCallConfigurationDefinition> getServiceCallConfigurations();

    public abstract HystrixConfigurationDefinition getDefaultHystrixConfiguration();

    public abstract List<HystrixConfigurationDefinition> getHystrixConfigurations();

    public abstract Resilience4jConfigurationDefinition getDefaultResilience4jConfiguration();

    public abstract List<Resilience4jConfigurationDefinition> getResilience4jConfigurations();

    protected void initCamelContext(T context) throws Exception {
        if (this.getStreamCache() != null) {
            context.setStreamCaching(CamelContextHelper.parseBoolean(context, (String)this.getStreamCache()));
        }
        if (this.getTrace() != null) {
            context.setTracing(CamelContextHelper.parseBoolean(context, (String)this.getTrace()));
        }
        if (this.getTracePattern() != null) {
            context.setTracingPattern(CamelContextHelper.parseText(context, (String)this.getTracePattern()));
        }
        if (this.getMessageHistory() != null) {
            context.setMessageHistory(CamelContextHelper.parseBoolean(context, (String)this.getMessageHistory()));
        }
        if (this.getLogMask() != null) {
            context.setLogMask(CamelContextHelper.parseBoolean(context, (String)this.getLogMask()));
        }
        if (this.getLogExhaustedMessageBody() != null) {
            context.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean(context, (String)this.getLogExhaustedMessageBody()));
        }
        if (this.getDelayer() != null) {
            context.setDelayer(CamelContextHelper.parseLong(context, (String)this.getDelayer()));
        }
        if (this.getErrorHandlerRef() != null) {
            ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).setErrorHandlerFactory((ErrorHandlerFactory)new ErrorHandlerBuilderRef(this.getErrorHandlerRef()));
        }
        if (this.getAutoStartup() != null) {
            context.setAutoStartup(CamelContextHelper.parseBoolean(context, (String)this.getAutoStartup()));
        }
        if (this.getUseMDCLogging() != null) {
            context.setUseMDCLogging(CamelContextHelper.parseBoolean(context, (String)this.getUseMDCLogging()));
        }
        if (this.getMDCLoggingKeysPattern() != null) {
            context.setMDCLoggingKeysPattern(CamelContextHelper.parseText(context, (String)this.getMDCLoggingKeysPattern()));
        }
        if (this.getUseDataType() != null) {
            context.setUseDataType(CamelContextHelper.parseBoolean(context, (String)this.getUseDataType()));
        }
        if (this.getUseBreadcrumb() != null) {
            context.setUseBreadcrumb(CamelContextHelper.parseBoolean(context, (String)this.getUseBreadcrumb()));
        }
        if (this.getAllowUseOriginalMessage() != null) {
            context.setAllowUseOriginalMessage(CamelContextHelper.parseBoolean(context, (String)this.getAllowUseOriginalMessage()));
        }
        if (this.getRuntimeEndpointRegistryEnabled() != null) {
            context.getRuntimeEndpointRegistry().setEnabled(CamelContextHelper.parseBoolean(context, (String)this.getRuntimeEndpointRegistryEnabled()).booleanValue());
        }
        if (this.getManagementNamePattern() != null) {
            context.getManagementNameStrategy().setNamePattern(CamelContextHelper.parseText(context, (String)this.getManagementNamePattern()));
        }
        if (this.getThreadNamePattern() != null) {
            context.getExecutorServiceManager().setThreadNamePattern(CamelContextHelper.parseText(context, (String)this.getThreadNamePattern()));
        }
        if (this.getShutdownRoute() != null) {
            context.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.getShutdownRunningTask() != null) {
            context.setShutdownRunningTask(this.getShutdownRunningTask());
        }
        if (this.getDataFormats() != null) {
            context.setDataFormats(this.getDataFormats().asMap());
        }
        if (this.getTransformers() != null) {
            context.setTransformers(this.getTransformers().getTransformers());
        }
        if (this.getValidators() != null) {
            context.setValidators(this.getValidators().getValidators());
        }
        if (this.getTypeConverterStatisticsEnabled() != null) {
            context.setTypeConverterStatisticsEnabled(this.getTypeConverterStatisticsEnabled());
        }
        if (this.getTypeConverterExists() != null) {
            context.getTypeConverterRegistry().setTypeConverterExists(this.getTypeConverterExists());
        }
        if (this.getTypeConverterExistsLoggingLevel() != null) {
            context.getTypeConverterRegistry().setTypeConverterExistsLoggingLevel(this.getTypeConverterExistsLoggingLevel());
        }
        if (this.getRestConfiguration() != null) {
            context.setRestConfiguration(this.getRestConfiguration().asRestConfiguration(context));
        }
        if (this.getDefaultServiceCallConfiguration() != null) {
            context.setServiceCallConfiguration(this.getDefaultServiceCallConfiguration());
        }
        if (this.getServiceCallConfigurations() != null) {
            for (ServiceCallConfigurationDefinition serviceCallConfigurationDefinition : this.getServiceCallConfigurations()) {
                context.addServiceCallConfiguration(serviceCallConfigurationDefinition.getId(), serviceCallConfigurationDefinition);
            }
        }
        if (this.getDefaultHystrixConfiguration() != null) {
            context.setHystrixConfiguration(this.getDefaultHystrixConfiguration());
        }
        if (this.getHystrixConfigurations() != null) {
            for (HystrixConfigurationDefinition hystrixConfigurationDefinition : this.getHystrixConfigurations()) {
                context.addHystrixConfiguration(hystrixConfigurationDefinition.getId(), hystrixConfigurationDefinition);
            }
        }
        if (this.getDefaultResilience4jConfiguration() != null) {
            context.setResilience4jConfiguration(this.getDefaultResilience4jConfiguration());
        }
        if (this.getResilience4jConfigurations() != null) {
            for (Resilience4jConfigurationDefinition resilience4jConfigurationDefinition : this.getResilience4jConfigurations()) {
                context.addResilience4jConfiguration(resilience4jConfigurationDefinition.getId(), resilience4jConfigurationDefinition);
            }
        }
    }

    protected void initThreadPoolProfiles(T context) throws Exception {
        HashSet<Object> defaultIds = new HashSet<Object>();
        Map profiles = context.getRegistry().findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", entry.getKey(), (Object)profile);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (this.getThreadPoolProfiles() != null && !this.getThreadPoolProfiles().isEmpty()) {
            for (ThreadPoolProfileDefinition definition : this.getThreadPoolProfiles()) {
                if (definition.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", (Object)definition.getId(), (Object)definition);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
                    defaultIds.add(definition.getId());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    private ThreadPoolProfile asThreadPoolProfile(CamelContext context, ThreadPoolProfileDefinition definition) throws Exception {
        ThreadPoolProfile answer = new ThreadPoolProfile();
        answer.setId(definition.getId());
        answer.setDefaultProfile(definition.getDefaultProfile());
        answer.setPoolSize(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getPoolSize()));
        answer.setMaxPoolSize(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaxPoolSize()));
        answer.setKeepAliveTime(CamelContextHelper.parseLong((CamelContext)context, (String)definition.getKeepAliveTime()));
        answer.setMaxQueueSize(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaxQueueSize()));
        answer.setAllowCoreThreadTimeOut(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAllowCoreThreadTimeOut()));
        answer.setRejectedPolicy(definition.getRejectedPolicy());
        answer.setTimeUnit(definition.getTimeUnit());
        return answer;
    }

    protected abstract void initBeanPostProcessor(T var1);

    protected void installRoutes() throws Exception {
        ArrayList builders = new ArrayList();
        if (this.getBuilderRefs() != null) {
            for (RouteBuilderDefinition builderRef : this.getBuilderRefs()) {
                RoutesBuilder routes = builderRef.createRoutes(this.getContext());
                if (routes != null) {
                    this.builders.add(routes);
                    continue;
                }
                throw new CamelException("Cannot find any routes with this RouteBuilder reference: " + builderRef);
            }
        }
        for (RoutesBuilder routeBuilder : this.builders) {
            this.getContext().addRoutes(routeBuilder);
        }
        for (RouteBuilder builder : builders) {
            this.postProcessBeforeInit(builder);
            this.getContext().addRoutes((RoutesBuilder)builder);
        }
    }

    protected abstract void postProcessBeforeInit(RouteBuilder var1);

    protected void findRouteBuilders() throws Exception {
        ContextScanDefinition contextScanDef;
        this.addPackageElementContentsToScanDefinition();
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (packageScanDef != null && packageScanDef.getPackages().size() > 0) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : packageScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (Object exclude : packageScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders((String)exclude);
                filter.addExcludePattern((String)exclude);
            }
            String[] normalized = this.normalizePackages(this.getContext(), packageScanDef.getPackages());
            this.findRouteBuildersByPackageScan(normalized, filter, this.builders);
        }
        if ((contextScanDef = this.getContextScan()) != null) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : contextScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : contextScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            boolean includeNonSingletons = contextScanDef.getIncludeNonSingletons() != null ? contextScanDef.getIncludeNonSingletons() : false;
            this.findRouteBuildersByContextScan(filter, includeNonSingletons, this.builders);
        }
    }

    protected abstract void findRouteBuildersByPackageScan(String[] var1, PackageScanFilter var2, List<RoutesBuilder> var3) throws Exception;

    protected abstract void findRouteBuildersByContextScan(PackageScanFilter var1, boolean var2, List<RoutesBuilder> var3) throws Exception;

    private void addPackageElementContentsToScanDefinition() {
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (this.getPackages() != null && this.getPackages().length > 0) {
            if (packageScanDef == null) {
                packageScanDef = new PackageScanDefinition();
                this.setPackageScan(packageScanDef);
            }
            for (String pkg : this.getPackages()) {
                packageScanDef.getPackages().add(pkg);
            }
        }
    }

    private String[] normalizePackages(T context, List<String> unnormalized) throws Exception {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : unnormalized) {
            name = context.resolvePropertyPlaceholders(name);
            if (!org.apache.camel.util.ObjectHelper.isNotEmpty((Object)(name = StringHelper.normalizeClassName((String)name)))) continue;
            LOG.trace("Using package: {} to scan for RouteBuilder classes", (Object)name);
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }

    private void setupCustomServices() {
        ReactiveExecutor reactiveExecutor;
        MessageHistoryFactory messageHistoryFactory;
        StreamCachingStrategy streamCachingStrategy;
        NodeIdFactory nodeIdFactory;
        UuidGenerator uuidGenerator;
        Debugger debugger;
        ProcessorFactory processorFactory;
        ThreadPoolFactory threadPoolFactory;
        ExecutorServiceManager executorServiceStrategy;
        FactoryFinderResolver factoryFinderResolver;
        ClassResolver classResolver;
        ModelJAXBContextFactory modelJAXBContextFactory = this.getBeanForType(ModelJAXBContextFactory.class);
        if (modelJAXBContextFactory != null) {
            LOG.info("Using custom ModelJAXBContextFactory: {}", (Object)modelJAXBContextFactory);
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setModelJAXBContextFactory(modelJAXBContextFactory);
        }
        if ((classResolver = this.getBeanForType(ClassResolver.class)) != null) {
            LOG.info("Using custom ClassResolver: {}", (Object)classResolver);
            this.getContext().setClassResolver(classResolver);
        }
        if ((factoryFinderResolver = this.getBeanForType(FactoryFinderResolver.class)) != null) {
            LOG.info("Using custom FactoryFinderResolver: {}", (Object)factoryFinderResolver);
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setFactoryFinderResolver(factoryFinderResolver);
        }
        if ((executorServiceStrategy = this.getBeanForType(ExecutorServiceManager.class)) != null) {
            LOG.info("Using custom ExecutorServiceStrategy: {}", (Object)executorServiceStrategy);
            this.getContext().setExecutorServiceManager(executorServiceStrategy);
        }
        if ((threadPoolFactory = this.getBeanForType(ThreadPoolFactory.class)) != null) {
            LOG.info("Using custom ThreadPoolFactory: {}", (Object)threadPoolFactory);
            this.getContext().getExecutorServiceManager().setThreadPoolFactory(threadPoolFactory);
        }
        if ((processorFactory = this.getBeanForType(ProcessorFactory.class)) != null) {
            LOG.info("Using custom ProcessorFactory: {}", (Object)processorFactory);
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setProcessorFactory(processorFactory);
        }
        if ((debugger = this.getBeanForType(Debugger.class)) != null) {
            LOG.info("Using custom Debugger: {}", (Object)debugger);
            this.getContext().setDebugger(debugger);
        }
        if ((uuidGenerator = this.getBeanForType(UuidGenerator.class)) != null) {
            LOG.info("Using custom UuidGenerator: {}", (Object)uuidGenerator);
            this.getContext().setUuidGenerator(uuidGenerator);
        }
        if ((nodeIdFactory = this.getBeanForType(NodeIdFactory.class)) != null) {
            LOG.info("Using custom NodeIdFactory: {}", (Object)nodeIdFactory);
            ((ExtendedCamelContext)this.getContext().adapt(ExtendedCamelContext.class)).setNodeIdFactory(nodeIdFactory);
        }
        if ((streamCachingStrategy = this.getBeanForType(StreamCachingStrategy.class)) != null) {
            LOG.info("Using custom StreamCachingStrategy: {}", (Object)streamCachingStrategy);
            this.getContext().setStreamCachingStrategy(streamCachingStrategy);
        }
        if ((messageHistoryFactory = this.getBeanForType(MessageHistoryFactory.class)) != null) {
            LOG.info("Using custom MessageHistoryFactory: {}", (Object)messageHistoryFactory);
            this.getContext().setMessageHistoryFactory(messageHistoryFactory);
        }
        if ((reactiveExecutor = this.getBeanForType(ReactiveExecutor.class)) != null) {
            this.getContext().setReactiveExecutor(reactiveExecutor);
        }
    }
}

