/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.utils;

import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PoolWorker
extends Thread {
    private static Logger log = LoggerFactory.getLogger(PoolWorker.class);
    final LinkedBlockingQueue<Runnable> queue;

    public PoolWorker(int capacity) {
        this.queue = capacity > 0 ? new LinkedBlockingQueue(capacity) : new LinkedBlockingQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Runnable r) {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            this.queue.add(r);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Runnable task;
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = this.queue;
            synchronized (linkedBlockingQueue) {
                while (this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException e) {
                        log.error("An interrupt occurred while queue is waiting: " + e.getMessage());
                        Thread.currentThread().interrupt();
                    }
                }
                task = this.queue.poll();
                if (task == null) {
                    continue;
                }
            }
            try {
                task.run();
                continue;
            }
            catch (RuntimeException e) {
                log.error("Thread pool is interrupted due to an issue: " + e.getMessage());
                continue;
            }
            break;
        }
    }
}

