/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache.springboot.customizer;

import java.util.Map;
import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.springboot.EhcacheComponentAutoConfiguration;
import org.apache.camel.component.ehcache.springboot.customizer.CacheConfigurationCustomizerConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.ehcache.config.CacheConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;

@Order(value=0x7FFFFFFF)
@Configuration
@Conditional(value={NestedConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@AutoConfigureBefore(value={EhcacheComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheConfigurationCustomizerConfiguration.class})
public class CacheConfigurationCustomizer
implements HasId,
ComponentCustomizer<EhcacheComponent> {
    @Autowired(required=false)
    private Map<String, CacheConfiguration> configurations;
    @Autowired
    private CacheConfigurationCustomizerConfiguration configuration;

    public void customize(EhcacheComponent component) {
        if (this.configurations != null && this.configuration.getMode() == CacheConfigurationCustomizerConfiguration.Mode.APPEND) {
            component.addCachesConfigurations(this.configurations);
        }
        if (this.configurations != null && this.configuration.getMode() == CacheConfigurationCustomizerConfiguration.Mode.REPLACE) {
            component.setCachesConfigurations(this.configurations);
        }
    }

    public String getId() {
        return "camel.component.ehcache.customizer.cache-configuration";
    }

    static class NestedConditions
    extends AllNestedConditions {
        public NestedConditions() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CamelAutoConfiguration.class})
        static class OnCamelAutoConfiguration {
            OnCamelAutoConfiguration() {
            }
        }
    }
}

