/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import mousio.etcd4j.EtcdClient;
import org.apache.camel.Endpoint;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdEndpoint;
import org.apache.camel.component.etcd.EtcdNamespace;
import org.apache.camel.support.DefaultProducer;

public abstract class AbstractEtcdProducer
extends DefaultProducer {
    private final EtcdConfiguration configuration;
    private final EtcdNamespace namespace;
    private final String path;
    private EtcdClient client;

    protected AbstractEtcdProducer(Endpoint endpoint, EtcdConfiguration configuration, EtcdNamespace namespace, String path) {
        super(endpoint);
        this.configuration = configuration;
        this.namespace = namespace;
        this.path = path;
        this.client = null;
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        super.doStop();
    }

    protected EtcdClient getClient() throws Exception {
        if (this.client == null) {
            this.client = ((EtcdEndpoint)this.getEndpoint()).createClient();
        }
        return this.client;
    }

    protected EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    protected EtcdNamespace getNamespace() {
        return this.namespace;
    }

    protected String getPath() {
        return this.path;
    }
}

