/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kms;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.CreateKeyRequest;
import com.amazonaws.services.kms.model.CreateKeyResult;
import com.amazonaws.services.kms.model.DescribeKeyRequest;
import com.amazonaws.services.kms.model.DescribeKeyResult;
import com.amazonaws.services.kms.model.DisableKeyRequest;
import com.amazonaws.services.kms.model.DisableKeyResult;
import com.amazonaws.services.kms.model.EnableKeyRequest;
import com.amazonaws.services.kms.model.EnableKeyResult;
import com.amazonaws.services.kms.model.ListKeysRequest;
import com.amazonaws.services.kms.model.ListKeysResult;
import com.amazonaws.services.kms.model.ScheduleKeyDeletionRequest;
import com.amazonaws.services.kms.model.ScheduleKeyDeletionResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.kms.KMSConfiguration;
import org.apache.camel.component.aws.kms.KMSEndpoint;
import org.apache.camel.component.aws.kms.KMSOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class KMSProducer
extends DefaultProducer {
    private transient String kmsProducerToString;

    public KMSProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listKeys: {
                this.listKeys(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case createKey: {
                this.createKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case disableKey: {
                this.disableKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case enableKey: {
                this.enableKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case scheduleKeyDeletion: {
                this.scheduleKeyDeletion(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case describeKey: {
                this.describeKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private KMSOperations determineOperation(Exchange exchange) {
        KMSOperations operation = (KMSOperations)((Object)exchange.getIn().getHeader("CamelAwsKMSOperation", KMSOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            throw new IllegalArgumentException("Operation must be specified");
        }
        return operation;
    }

    protected KMSConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.kmsProducerToString == null) {
            this.kmsProducerToString = "KMSProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.kmsProducerToString;
    }

    public KMSEndpoint getEndpoint() {
        return (KMSEndpoint)super.getEndpoint();
    }

    private void listKeys(AWSKMS kmsClient, Exchange exchange) {
        ListKeysResult result;
        ListKeysRequest request = new ListKeysRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSLimit"))) {
            int limit = (Integer)exchange.getIn().getHeader("CamelAwsKMSLimit", Integer.class);
            request.withLimit(Integer.valueOf(limit));
        }
        try {
            result = kmsClient.listKeys(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("List Keys command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = KMSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createKey(AWSKMS kmsClient, Exchange exchange) {
        CreateKeyResult result;
        CreateKeyRequest request = new CreateKeyRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSDescription"))) {
            String description = (String)exchange.getIn().getHeader("CamelAwsKMSDescription", String.class);
            request.withDescription(description);
        }
        try {
            result = kmsClient.createKey(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Create Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = KMSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void disableKey(AWSKMS kmsClient, Exchange exchange) {
        DisableKeyResult result;
        DisableKeyRequest request = new DisableKeyRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        request.withKeyId(keyId);
        try {
            result = kmsClient.disableKey(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Disable Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = KMSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void scheduleKeyDeletion(AWSKMS kmsClient, Exchange exchange) {
        ScheduleKeyDeletionResult result;
        ScheduleKeyDeletionRequest request = new ScheduleKeyDeletionRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        request.withKeyId(keyId);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSPendingWindowInDays"))) {
            int pendingWindows = (Integer)exchange.getIn().getHeader("CamelAwsKMSPendingWindowInDays", Integer.class);
            request.withPendingWindowInDays(Integer.valueOf(pendingWindows));
        }
        try {
            result = kmsClient.scheduleKeyDeletion(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Schedule Key Deletion command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = KMSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeKey(AWSKMS kmsClient, Exchange exchange) {
        DescribeKeyResult result;
        DescribeKeyRequest request = new DescribeKeyRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        request.withKeyId(keyId);
        try {
            result = kmsClient.describeKey(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Describe Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = KMSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void enableKey(AWSKMS kmsClient, Exchange exchange) {
        EnableKeyResult result;
        EnableKeyRequest request = new EnableKeyRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        request.withKeyId(keyId);
        try {
            result = kmsClient.enableKey(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Enable Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = KMSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

