/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.mq;

import com.amazonaws.Protocol;
import com.amazonaws.services.mq.AmazonMQ;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.mq.MQEndpoint;
import org.apache.camel.component.aws.mq.MQOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class MQEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return MQEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return MQEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "amazonMqClient": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setAmazonMqClient((AmazonMQ)MQEndpointConfigurer.property((CamelContext)camelContext, AmazonMQ.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setOperation((MQOperations)((Object)MQEndpointConfigurer.property((CamelContext)camelContext, MQOperations.class, (Object)value)));
                return true;
            }
            case "proxyProtocol": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)MQEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((MQEndpoint)((Object)endpoint)).setStartScheduler((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((MQEndpoint)((Object)endpoint)).setInitialDelay((Long)MQEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((MQEndpoint)((Object)endpoint)).setDelay((Long)MQEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((MQEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)MQEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((MQEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((MQEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)MQEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((MQEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)MQEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((MQEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((MQEndpoint)((Object)endpoint)).setGreedy((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((MQEndpoint)((Object)endpoint)).setScheduler((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((MQEndpoint)((Object)endpoint)).setSchedulerProperties((Map)MQEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((MQEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)MQEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((MQEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((MQEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((MQEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((MQEndpoint)((Object)endpoint)).setRepeatCount((Long)MQEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((MQEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((MQEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((MQEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)MQEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((MQEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)MQEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((MQEndpoint)((Object)endpoint)).setSynchronous((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((MQEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "amazonmqclient": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setAmazonMqClient((AmazonMQ)MQEndpointConfigurer.property((CamelContext)camelContext, AmazonMQ.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setOperation((MQOperations)((Object)MQEndpointConfigurer.property((CamelContext)camelContext, MQOperations.class, (Object)value)));
                return true;
            }
            case "proxyprotocol": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)MQEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((MQEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((MQEndpoint)((Object)endpoint)).setStartScheduler((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((MQEndpoint)((Object)endpoint)).setInitialDelay((Long)MQEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((MQEndpoint)((Object)endpoint)).setDelay((Long)MQEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((MQEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)MQEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((MQEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((MQEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)MQEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((MQEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)MQEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((MQEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((MQEndpoint)((Object)endpoint)).setGreedy((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((MQEndpoint)((Object)endpoint)).setScheduler((String)MQEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((MQEndpoint)((Object)endpoint)).setSchedulerProperties((Map)MQEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((MQEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)MQEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((MQEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((MQEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((MQEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)MQEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((MQEndpoint)((Object)endpoint)).setRepeatCount((Long)MQEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((MQEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((MQEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((MQEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)MQEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((MQEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)MQEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((MQEndpoint)((Object)endpoint)).setSynchronous((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((MQEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)MQEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

