/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The websocket component provides websocket endpoints with Jetty for
 * communicating with clients using websocket.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WebsocketEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Jetty Websocket component.
     */
    public interface WebsocketEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWebsocketEndpointConsumerBuilder advanced() {
            return (AdvancedWebsocketEndpointConsumerBuilder) this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default WebsocketEndpointConsumerBuilder maxBinaryMessageSize(
                Integer maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default WebsocketEndpointConsumerBuilder maxBinaryMessageSize(
                String maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WebsocketEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WebsocketEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether to enable session support which enables HttpSession for each
         * http request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WebsocketEndpointConsumerBuilder sessionSupport(
                boolean sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * Whether to enable session support which enables HttpSession for each
         * http request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WebsocketEndpointConsumerBuilder sessionSupport(
                String sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * Set a resource path for static resources (such as .html files etc).
         * The resources can be loaded from classpath, if you prefix with
         * classpath:, otherwise the resources is loaded from file system or
         * from JAR files. For example to load from root classpath use
         * classpath:., or classpath:WEB-INF/static If not configured (eg null)
         * then no static resource is in use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default WebsocketEndpointConsumerBuilder staticResources(
                String staticResources) {
            doSetProperty("staticResources", staticResources);
            return this;
        }
        /**
         * The CORS allowed origins. Use to allow all.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointConsumerBuilder allowedOrigins(
                String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointConsumerBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointConsumerBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Context path for filtering CORS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointConsumerBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: monitoring
         */
        default WebsocketEndpointConsumerBuilder enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: monitoring
         */
        default WebsocketEndpointConsumerBuilder enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default WebsocketEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default WebsocketEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Jetty Websocket
     * component.
     */
    public interface AdvancedWebsocketEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default WebsocketEndpointConsumerBuilder basic() {
            return (WebsocketEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWebsocketEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWebsocketEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWebsocketEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWebsocketEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder bufferSize(
                Integer bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder bufferSize(
                String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxIdleTime(
                Integer maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxIdleTime(
                String maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxTextMessageSize(
                Integer maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder maxTextMessageSize(
                String maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder minVersion(
                Integer minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder minVersion(
                String minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Jetty Websocket component.
     */
    public interface WebsocketEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWebsocketEndpointProducerBuilder advanced() {
            return (AdvancedWebsocketEndpointProducerBuilder) this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default WebsocketEndpointProducerBuilder maxBinaryMessageSize(
                Integer maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default WebsocketEndpointProducerBuilder maxBinaryMessageSize(
                String maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default WebsocketEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default WebsocketEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Timeout in millis when sending to a websocket channel. The default
         * timeout is 30000 (30 seconds).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         */
        default WebsocketEndpointProducerBuilder sendTimeout(Integer sendTimeout) {
            doSetProperty("sendTimeout", sendTimeout);
            return this;
        }
        /**
         * Timeout in millis when sending to a websocket channel. The default
         * timeout is 30000 (30 seconds).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         */
        default WebsocketEndpointProducerBuilder sendTimeout(String sendTimeout) {
            doSetProperty("sendTimeout", sendTimeout);
            return this;
        }
        /**
         * To send to all websocket subscribers. Can be used to configure on
         * endpoint level, instead of having to use the
         * WebsocketConstants.SEND_TO_ALL header on the message.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default WebsocketEndpointProducerBuilder sendToAll(Boolean sendToAll) {
            doSetProperty("sendToAll", sendToAll);
            return this;
        }
        /**
         * To send to all websocket subscribers. Can be used to configure on
         * endpoint level, instead of having to use the
         * WebsocketConstants.SEND_TO_ALL header on the message.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default WebsocketEndpointProducerBuilder sendToAll(String sendToAll) {
            doSetProperty("sendToAll", sendToAll);
            return this;
        }
        /**
         * The CORS allowed origins. Use to allow all.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointProducerBuilder allowedOrigins(
                String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointProducerBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointProducerBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Context path for filtering CORS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointProducerBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: monitoring
         */
        default WebsocketEndpointProducerBuilder enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: monitoring
         */
        default WebsocketEndpointProducerBuilder enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default WebsocketEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default WebsocketEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Jetty Websocket
     * component.
     */
    public interface AdvancedWebsocketEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default WebsocketEndpointProducerBuilder basic() {
            return (WebsocketEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder bufferSize(
                Integer bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder bufferSize(
                String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder maxIdleTime(
                Integer maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder maxIdleTime(
                String maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder maxTextMessageSize(
                Integer maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder maxTextMessageSize(
                String maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder minVersion(
                Integer minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder minVersion(
                String minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Jetty Websocket component.
     */
    public interface WebsocketEndpointBuilder
            extends
                WebsocketEndpointConsumerBuilder, WebsocketEndpointProducerBuilder {
        default AdvancedWebsocketEndpointBuilder advanced() {
            return (AdvancedWebsocketEndpointBuilder) this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default WebsocketEndpointBuilder maxBinaryMessageSize(
                Integer maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in bytes that the websocket created by
         * the websocketServlet may be accept before closing. (Default is -1 -
         * or unlimited).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default WebsocketEndpointBuilder maxBinaryMessageSize(
                String maxBinaryMessageSize) {
            doSetProperty("maxBinaryMessageSize", maxBinaryMessageSize);
            return this;
        }
        /**
         * The CORS allowed origins. Use to allow all.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointBuilder allowedOrigins(String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Whether to enable CORS.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * Context path for filtering CORS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: cors
         */
        default WebsocketEndpointBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: monitoring
         */
        default WebsocketEndpointBuilder enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: monitoring
         */
        default WebsocketEndpointBuilder enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default WebsocketEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default WebsocketEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Jetty Websocket component.
     */
    public interface AdvancedWebsocketEndpointBuilder
            extends
                AdvancedWebsocketEndpointConsumerBuilder, AdvancedWebsocketEndpointProducerBuilder {
        default WebsocketEndpointBuilder basic() {
            return (WebsocketEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder bufferSize(Integer bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the buffer size of the websocketServlet, which is also the max
         * frame byte size (default 8192).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder maxIdleTime(Integer maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Set the time in ms that the websocket created by the websocketServlet
         * may be idle before closing. (default is 300000).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder maxIdleTime(String maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder maxTextMessageSize(
                Integer maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the size in characters that the websocket created
         * by the websocketServlet may be accept before closing.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder maxTextMessageSize(
                String maxTextMessageSize) {
            doSetProperty("maxTextMessageSize", maxTextMessageSize);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder minVersion(Integer minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Can be used to set the minimum protocol version accepted for the
         * websocketServlet. (Default 13 - the RFC6455 version).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder minVersion(String minVersion) {
            doSetProperty("minVersion", minVersion);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWebsocketEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Jetty Websocket (camel-websocket)
     * The websocket component provides websocket endpoints with Jetty for
     * communicating with clients using websocket.
     * 
     * Category: websocket
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-websocket
     * 
     * Syntax: <code>websocket:host:port/resourceUri</code>
     * 
     * Path parameter: host
     * The hostname. The default value is 0.0.0.0. Setting this option on the
     * component will use the component configured value as default.
     * Default value: 0.0.0.0
     * 
     * Path parameter: port
     * The port number. The default value is 9292. Setting this option on the
     * component will use the component configured value as default.
     * Default value: 9292
     * 
     * Path parameter: resourceUri (required)
     * Name of the websocket channel to use
     */
    default WebsocketEndpointBuilder websocket(String path) {
        class WebsocketEndpointBuilderImpl extends AbstractEndpointBuilder implements WebsocketEndpointBuilder, AdvancedWebsocketEndpointBuilder {
            public WebsocketEndpointBuilderImpl(String path) {
                super("websocket", path);
            }
        }
        return new WebsocketEndpointBuilderImpl(path);
    }
}