/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The rabbitmq component allows you produce and consume messages from RabbitMQ
 * instances.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RabbitMQEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the RabbitMQ component.
     */
    public interface RabbitMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRabbitMQEndpointConsumerBuilder advanced() {
            return (AdvancedRabbitMQEndpointConsumerBuilder) this;
        }
        /**
         * If this option is set, camel-rabbitmq will try to create connection
         * based on the setting of option addresses. The addresses value is a
         * string which looks like server1:12345, server2:12345.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder autoDelete(boolean autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder autoDelete(String autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder automaticRecoveryEnabled(
                Boolean automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder automaticRecoveryEnabled(
                String automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option is a: <code>com.rabbitmq.client.ConnectionFactory</code>
         * type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder connectionFactory(
                Object connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option will be converted to a
         * <code>com.rabbitmq.client.ConnectionFactory</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The name of the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder deadLetterExchange(
                String deadLetterExchange) {
            doSetProperty("deadLetterExchange", deadLetterExchange);
            return this;
        }
        /**
         * The type of the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder deadLetterExchangeType(
                String deadLetterExchangeType) {
            doSetProperty("deadLetterExchangeType", deadLetterExchangeType);
            return this;
        }
        /**
         * The name of the dead letter queue.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder deadLetterQueue(
                String deadLetterQueue) {
            doSetProperty("deadLetterQueue", deadLetterQueue);
            return this;
        }
        /**
         * The routing key for the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder deadLetterRoutingKey(
                String deadLetterRoutingKey) {
            doSetProperty("deadLetterRoutingKey", deadLetterRoutingKey);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder declare(boolean declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder declare(String declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder durable(boolean durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder durable(String durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * The exchange type such as direct or topic.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder exchangeType(String exchangeType) {
            doSetProperty("exchangeType", exchangeType);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder exclusive(boolean exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder exclusive(String exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * The hostname of the running rabbitmq instance or cluster.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder hostname(String hostname) {
            doSetProperty("hostname", hostname);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder passive(boolean passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder passive(String passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder portNumber(int portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder portNumber(String portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * The queue to receive messages from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder queue(String queue) {
            doSetProperty("queue", queue);
            return this;
        }
        /**
         * The routing key to use when binding a consumer queue to the exchange.
         * For producer routing keys, you set the header rabbitmq.ROUTING_KEY.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder routingKey(String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder skipExchangeDeclare(
                boolean skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder skipExchangeDeclare(
                String skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder skipQueueBind(
                boolean skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder skipQueueBind(
                String skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder skipQueueDeclare(
                boolean skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder skipQueueDeclare(
                String skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * The vhost for the channel.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointConsumerBuilder vhost(String vhost) {
            doSetProperty("vhost", vhost);
            return this;
        }
        /**
         * If messages should be auto acknowledged.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * If messages should be auto acknowledged.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Number of concurrent consumers when consuming from broker. (eg
         * similar as to the same option for the JMS component).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Number of concurrent consumers when consuming from broker. (eg
         * similar as to the same option for the JMS component).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Request exclusive access to the queue (meaning only this consumer can
         * access the queue). This is useful when you want a long-lived shared
         * queue to be temporarily accessible by just one consumer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder exclusiveConsumer(
                boolean exclusiveConsumer) {
            doSetProperty("exclusiveConsumer", exclusiveConsumer);
            return this;
        }
        /**
         * Request exclusive access to the queue (meaning only this consumer can
         * access the queue). This is useful when you want a long-lived shared
         * queue to be temporarily accessible by just one consumer.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder exclusiveConsumer(
                String exclusiveConsumer) {
            doSetProperty("exclusiveConsumer", exclusiveConsumer);
            return this;
        }
        /**
         * The maximum number of messages that the server will deliver, 0 if
         * unlimited. You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchCount(int prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * The maximum number of messages that the server will deliver, 0 if
         * unlimited. You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchCount(
                String prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Enables the quality of service on the RabbitMQConsumer side. You need
         * to specify the option of prefetchSize, prefetchCount, prefetchGlobal
         * at the same time.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchEnabled(
                boolean prefetchEnabled) {
            doSetProperty("prefetchEnabled", prefetchEnabled);
            return this;
        }
        /**
         * Enables the quality of service on the RabbitMQConsumer side. You need
         * to specify the option of prefetchSize, prefetchCount, prefetchGlobal
         * at the same time.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchEnabled(
                String prefetchEnabled) {
            doSetProperty("prefetchEnabled", prefetchEnabled);
            return this;
        }
        /**
         * If the settings should be applied to the entire channel rather than
         * each consumer You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchGlobal(
                boolean prefetchGlobal) {
            doSetProperty("prefetchGlobal", prefetchGlobal);
            return this;
        }
        /**
         * If the settings should be applied to the entire channel rather than
         * each consumer You need to specify the option of prefetchSize,
         * prefetchCount, prefetchGlobal at the same time.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchGlobal(
                String prefetchGlobal) {
            doSetProperty("prefetchGlobal", prefetchGlobal);
            return this;
        }
        /**
         * The maximum amount of content (measured in octets) that the server
         * will deliver, 0 if unlimited. You need to specify the option of
         * prefetchSize, prefetchCount, prefetchGlobal at the same time.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchSize(int prefetchSize) {
            doSetProperty("prefetchSize", prefetchSize);
            return this;
        }
        /**
         * The maximum amount of content (measured in octets) that the server
         * will deliver, 0 if unlimited. You need to specify the option of
         * prefetchSize, prefetchCount, prefetchGlobal at the same time.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default RabbitMQEndpointConsumerBuilder prefetchSize(String prefetchSize) {
            doSetProperty("prefetchSize", prefetchSize);
            return this;
        }
        /**
         * Password for authenticated access.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Enables SSL on connection, accepted value are true, TLS and 'SSLv3.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointConsumerBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option is a: <code>javax.net.ssl.TrustManager</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointConsumerBuilder trustManager(Object trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.TrustManager</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointConsumerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Username in case of authenticated access.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the RabbitMQ component.
     */
    public interface AdvancedRabbitMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RabbitMQEndpointConsumerBuilder basic() {
            return (RabbitMQEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRabbitMQEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The consumer uses a Thread Pool Executor with a fixed number of
         * threads. This setting allows you to set that number of threads.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRabbitMQEndpointConsumerBuilder threadPoolSize(
                int threadPoolSize) {
            doSetProperty("threadPoolSize", threadPoolSize);
            return this;
        }
        /**
         * The consumer uses a Thread Pool Executor with a fixed number of
         * threads. This setting allows you to set that number of threads.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRabbitMQEndpointConsumerBuilder threadPoolSize(
                String threadPoolSize) {
            doSetProperty("threadPoolSize", threadPoolSize);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. For example to declare a queue with
         * message ttl argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder args(
                Map<String, Object> args) {
            doSetProperty("args", args);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. For example to declare a queue with
         * message ttl argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder args(String args) {
            doSetProperty("args", args);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder clientProperties(
                Map<String, Object> clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder clientProperties(
                String clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder networkRecoveryInterval(
                Integer networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder networkRecoveryInterval(
                String networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedChannelMax(
                int requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedChannelMax(
                String requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedFrameMax(
                int requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedFrameMax(
                String requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedHeartbeat(
                int requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestedHeartbeat(
                String requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeout(
                long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder topologyRecoveryEnabled(
                Boolean topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder topologyRecoveryEnabled(
                String topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointConsumerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the RabbitMQ component.
     */
    public interface RabbitMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRabbitMQEndpointProducerBuilder advanced() {
            return (AdvancedRabbitMQEndpointProducerBuilder) this;
        }
        /**
         * If this option is set, camel-rabbitmq will try to create connection
         * based on the setting of option addresses. The addresses value is a
         * string which looks like server1:12345, server2:12345.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder autoDelete(boolean autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder autoDelete(String autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder automaticRecoveryEnabled(
                Boolean automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder automaticRecoveryEnabled(
                String automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option is a: <code>com.rabbitmq.client.ConnectionFactory</code>
         * type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder connectionFactory(
                Object connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option will be converted to a
         * <code>com.rabbitmq.client.ConnectionFactory</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The name of the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder deadLetterExchange(
                String deadLetterExchange) {
            doSetProperty("deadLetterExchange", deadLetterExchange);
            return this;
        }
        /**
         * The type of the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder deadLetterExchangeType(
                String deadLetterExchangeType) {
            doSetProperty("deadLetterExchangeType", deadLetterExchangeType);
            return this;
        }
        /**
         * The name of the dead letter queue.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder deadLetterQueue(
                String deadLetterQueue) {
            doSetProperty("deadLetterQueue", deadLetterQueue);
            return this;
        }
        /**
         * The routing key for the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder deadLetterRoutingKey(
                String deadLetterRoutingKey) {
            doSetProperty("deadLetterRoutingKey", deadLetterRoutingKey);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder declare(boolean declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder declare(String declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder durable(boolean durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder durable(String durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * The exchange type such as direct or topic.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder exchangeType(String exchangeType) {
            doSetProperty("exchangeType", exchangeType);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder exclusive(boolean exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder exclusive(String exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * The hostname of the running rabbitmq instance or cluster.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder hostname(String hostname) {
            doSetProperty("hostname", hostname);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder passive(boolean passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder passive(String passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder portNumber(int portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder portNumber(String portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * The queue to receive messages from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder queue(String queue) {
            doSetProperty("queue", queue);
            return this;
        }
        /**
         * The routing key to use when binding a consumer queue to the exchange.
         * For producer routing keys, you set the header rabbitmq.ROUTING_KEY.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder routingKey(String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder skipExchangeDeclare(
                boolean skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder skipExchangeDeclare(
                String skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder skipQueueBind(
                boolean skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder skipQueueBind(
                String skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder skipQueueDeclare(
                boolean skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder skipQueueDeclare(
                String skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * The vhost for the channel.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointProducerBuilder vhost(String vhost) {
            doSetProperty("vhost", vhost);
            return this;
        }
        /**
         * Allow pass null values to header.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder allowNullHeaders(
                boolean allowNullHeaders) {
            doSetProperty("allowNullHeaders", allowNullHeaders);
            return this;
        }
        /**
         * Allow pass null values to header.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder allowNullHeaders(
                String allowNullHeaders) {
            doSetProperty("allowNullHeaders", allowNullHeaders);
            return this;
        }
        /**
         * If the bridgeEndpoint is true, the producer will ignore the message
         * header of rabbitmq.EXCHANGE_NAME and rabbitmq.ROUTING_KEY.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder bridgeEndpoint(
                boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the bridgeEndpoint is true, the producer will ignore the message
         * header of rabbitmq.EXCHANGE_NAME and rabbitmq.ROUTING_KEY.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder bridgeEndpoint(
                String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * Get maximum number of opened channel in pool.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxSize(
                int channelPoolMaxSize) {
            doSetProperty("channelPoolMaxSize", channelPoolMaxSize);
            return this;
        }
        /**
         * Get maximum number of opened channel in pool.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxSize(
                String channelPoolMaxSize) {
            doSetProperty("channelPoolMaxSize", channelPoolMaxSize);
            return this;
        }
        /**
         * Set the maximum number of milliseconds to wait for a channel from the
         * pool.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxWait(
                long channelPoolMaxWait) {
            doSetProperty("channelPoolMaxWait", channelPoolMaxWait);
            return this;
        }
        /**
         * Set the maximum number of milliseconds to wait for a channel from the
         * pool.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder channelPoolMaxWait(
                String channelPoolMaxWait) {
            doSetProperty("channelPoolMaxWait", channelPoolMaxWait);
            return this;
        }
        /**
         * When true, an exception will be thrown when the message cannot be
         * delivered (basic.return) and the message is marked as mandatory.
         * PublisherAcknowledgement will also be activated in this case. See
         * also publisher acknowledgements - When will messages be confirmed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder guaranteedDeliveries(
                boolean guaranteedDeliveries) {
            doSetProperty("guaranteedDeliveries", guaranteedDeliveries);
            return this;
        }
        /**
         * When true, an exception will be thrown when the message cannot be
         * delivered (basic.return) and the message is marked as mandatory.
         * PublisherAcknowledgement will also be activated in this case. See
         * also publisher acknowledgements - When will messages be confirmed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder guaranteedDeliveries(
                String guaranteedDeliveries) {
            doSetProperty("guaranteedDeliveries", guaranteedDeliveries);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue consumer immediately. If this flag is set, the
         * server will return an undeliverable message with a Return method. If
         * this flag is zero, the server will queue the message, but with no
         * guarantee that it will ever be consumed. If the header is present
         * rabbitmq.IMMEDIATE it will override this option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder immediate(boolean immediate) {
            doSetProperty("immediate", immediate);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue consumer immediately. If this flag is set, the
         * server will return an undeliverable message with a Return method. If
         * this flag is zero, the server will queue the message, but with no
         * guarantee that it will ever be consumed. If the header is present
         * rabbitmq.IMMEDIATE it will override this option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder immediate(String immediate) {
            doSetProperty("immediate", immediate);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue. If this flag is set, the server will return an
         * unroutable message with a Return method. If this flag is zero, the
         * server silently drops the message. If the header is present
         * rabbitmq.MANDATORY it will override this option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder mandatory(boolean mandatory) {
            doSetProperty("mandatory", mandatory);
            return this;
        }
        /**
         * This flag tells the server how to react if the message cannot be
         * routed to a queue. If this flag is set, the server will return an
         * unroutable message with a Return method. If this flag is zero, the
         * server silently drops the message. If the header is present
         * rabbitmq.MANDATORY it will override this option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder mandatory(String mandatory) {
            doSetProperty("mandatory", mandatory);
            return this;
        }
        /**
         * When true, the message will be published with publisher
         * acknowledgements turned on.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgements(
                boolean publisherAcknowledgements) {
            doSetProperty("publisherAcknowledgements", publisherAcknowledgements);
            return this;
        }
        /**
         * When true, the message will be published with publisher
         * acknowledgements turned on.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgements(
                String publisherAcknowledgements) {
            doSetProperty("publisherAcknowledgements", publisherAcknowledgements);
            return this;
        }
        /**
         * The amount of time in milliseconds to wait for a basic.ack response
         * from RabbitMQ server.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgementsTimeout(
                long publisherAcknowledgementsTimeout) {
            doSetProperty("publisherAcknowledgementsTimeout", publisherAcknowledgementsTimeout);
            return this;
        }
        /**
         * The amount of time in milliseconds to wait for a basic.ack response
         * from RabbitMQ server.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         */
        default RabbitMQEndpointProducerBuilder publisherAcknowledgementsTimeout(
                String publisherAcknowledgementsTimeout) {
            doSetProperty("publisherAcknowledgementsTimeout", publisherAcknowledgementsTimeout);
            return this;
        }
        /**
         * Password for authenticated access.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Enables SSL on connection, accepted value are true, TLS and 'SSLv3.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointProducerBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option is a: <code>javax.net.ssl.TrustManager</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointProducerBuilder trustManager(Object trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.TrustManager</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointProducerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Username in case of authenticated access.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the RabbitMQ component.
     */
    public interface AdvancedRabbitMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default RabbitMQEndpointProducerBuilder basic() {
            return (RabbitMQEndpointProducerBuilder) this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. For example to declare a queue with
         * message ttl argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder args(
                Map<String, Object> args) {
            doSetProperty("args", args);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. For example to declare a queue with
         * message ttl argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder args(String args) {
            doSetProperty("args", args);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder clientProperties(
                Map<String, Object> clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder clientProperties(
                String clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder networkRecoveryInterval(
                Integer networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder networkRecoveryInterval(
                String networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedChannelMax(
                int requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedChannelMax(
                String requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedFrameMax(
                int requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedFrameMax(
                String requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedHeartbeat(
                int requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestedHeartbeat(
                String requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeout(
                long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder topologyRecoveryEnabled(
                Boolean topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder topologyRecoveryEnabled(
                String topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointProducerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }

    /**
     * Builder for endpoint for the RabbitMQ component.
     */
    public interface RabbitMQEndpointBuilder
            extends
                RabbitMQEndpointConsumerBuilder, RabbitMQEndpointProducerBuilder {
        default AdvancedRabbitMQEndpointBuilder advanced() {
            return (AdvancedRabbitMQEndpointBuilder) this;
        }
        /**
         * If this option is set, camel-rabbitmq will try to create connection
         * based on the setting of option addresses. The addresses value is a
         * string which looks like server1:12345, server2:12345.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder addresses(String addresses) {
            doSetProperty("addresses", addresses);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder autoDelete(boolean autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * If it is true, the exchange will be deleted when it is no longer in
         * use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder autoDelete(String autoDelete) {
            doSetProperty("autoDelete", autoDelete);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder automaticRecoveryEnabled(
                Boolean automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection automatic recovery (uses connection implementation
         * that performs automatic recovery when existing connection has
         * failures).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder automaticRecoveryEnabled(
                String automaticRecoveryEnabled) {
            doSetProperty("automaticRecoveryEnabled", automaticRecoveryEnabled);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option is a: <code>com.rabbitmq.client.ConnectionFactory</code>
         * type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder connectionFactory(
                Object connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * To use a custom RabbitMQ connection factory. When this option is set,
         * all connection options (connectionTimeout, requestedChannelMax...)
         * set on URI are not used.
         * 
         * The option will be converted to a
         * <code>com.rabbitmq.client.ConnectionFactory</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The name of the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder deadLetterExchange(
                String deadLetterExchange) {
            doSetProperty("deadLetterExchange", deadLetterExchange);
            return this;
        }
        /**
         * The type of the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder deadLetterExchangeType(
                String deadLetterExchangeType) {
            doSetProperty("deadLetterExchangeType", deadLetterExchangeType);
            return this;
        }
        /**
         * The name of the dead letter queue.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder deadLetterQueue(String deadLetterQueue) {
            doSetProperty("deadLetterQueue", deadLetterQueue);
            return this;
        }
        /**
         * The routing key for the dead letter exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder deadLetterRoutingKey(
                String deadLetterRoutingKey) {
            doSetProperty("deadLetterRoutingKey", deadLetterRoutingKey);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder declare(boolean declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If the option is true, camel declare the exchange and queue name and
         * bind them together. If the option is false, camel won't declare the
         * exchange and queue name on the server.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder declare(String declare) {
            doSetProperty("declare", declare);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder durable(boolean durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * If we are declaring a durable exchange (the exchange will survive a
         * server restart).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder durable(String durable) {
            doSetProperty("durable", durable);
            return this;
        }
        /**
         * The exchange type such as direct or topic.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder exchangeType(String exchangeType) {
            doSetProperty("exchangeType", exchangeType);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder exclusive(boolean exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * Exclusive queues may only be accessed by the current connection, and
         * are deleted when that connection closes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder exclusive(String exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * The hostname of the running rabbitmq instance or cluster.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder hostname(String hostname) {
            doSetProperty("hostname", hostname);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder passive(boolean passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Passive queues depend on the queue already to be available at
         * RabbitMQ.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder passive(String passive) {
            doSetProperty("passive", passive);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder portNumber(int portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * Port number for the host with the running rabbitmq instance or
         * cluster. Default value is 5672.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder portNumber(String portNumber) {
            doSetProperty("portNumber", portNumber);
            return this;
        }
        /**
         * The queue to receive messages from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder queue(String queue) {
            doSetProperty("queue", queue);
            return this;
        }
        /**
         * The routing key to use when binding a consumer queue to the exchange.
         * For producer routing keys, you set the header rabbitmq.ROUTING_KEY.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder routingKey(String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder skipExchangeDeclare(
                boolean skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * This can be used if we need to declare the queue but not the
         * exchange.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder skipExchangeDeclare(
                String skipExchangeDeclare) {
            doSetProperty("skipExchangeDeclare", skipExchangeDeclare);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder skipQueueBind(boolean skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the queue will not be bound to the exchange after declaring
         * it.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder skipQueueBind(String skipQueueBind) {
            doSetProperty("skipQueueBind", skipQueueBind);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder skipQueueDeclare(
                boolean skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * If true the producer will not declare and bind a queue. This can be
         * used for directing messages via an existing routing key.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder skipQueueDeclare(String skipQueueDeclare) {
            doSetProperty("skipQueueDeclare", skipQueueDeclare);
            return this;
        }
        /**
         * The vhost for the channel.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RabbitMQEndpointBuilder vhost(String vhost) {
            doSetProperty("vhost", vhost);
            return this;
        }
        /**
         * Password for authenticated access.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Enables SSL on connection, accepted value are true, TLS and 'SSLv3.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option is a: <code>javax.net.ssl.TrustManager</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointBuilder trustManager(Object trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Configure SSL trust manager, SSL should be enabled for this option to
         * be effective.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.TrustManager</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * Username in case of authenticated access.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default RabbitMQEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the RabbitMQ component.
     */
    public interface AdvancedRabbitMQEndpointBuilder
            extends
                AdvancedRabbitMQEndpointConsumerBuilder, AdvancedRabbitMQEndpointProducerBuilder {
        default RabbitMQEndpointBuilder basic() {
            return (RabbitMQEndpointBuilder) this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. For example to declare a queue with
         * message ttl argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder args(Map<String, Object> args) {
            doSetProperty("args", args);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each: Exchange: arg.exchange. Queue:
         * arg.queue. Binding: arg.binding. For example to declare a queue with
         * message ttl argument:
         * http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder args(String args) {
            doSetProperty("args", args);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder clientProperties(
                Map<String, Object> clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection client properties (client info used in negotiating with
         * the server).
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder clientProperties(
                String clientProperties) {
            doSetProperty("clientProperties", clientProperties);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder networkRecoveryInterval(
                Integer networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Network recovery interval in milliseconds (interval used when
         * recovering from network failure).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder networkRecoveryInterval(
                String networkRecoveryInterval) {
            doSetProperty("networkRecoveryInterval", networkRecoveryInterval);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestedChannelMax(
                int requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested channel max (max number of channels offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestedChannelMax(
                String requestedChannelMax) {
            doSetProperty("requestedChannelMax", requestedChannelMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestedFrameMax(
                int requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested frame max (max size of frame offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestedFrameMax(
                String requestedFrameMax) {
            doSetProperty("requestedFrameMax", requestedFrameMax);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestedHeartbeat(
                int requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Connection requested heartbeat (heart-beat in seconds offered).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestedHeartbeat(
                String requestedHeartbeat) {
            doSetProperty("requestedHeartbeat", requestedHeartbeat);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeout(
                long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Set requestTimeoutCheckerInterval for inOut exchange.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder topologyRecoveryEnabled(
                Boolean topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * Enables connection topology recovery (should topology recovery be
         * performed).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder topologyRecoveryEnabled(
                String topologyRecoveryEnabled) {
            doSetProperty("topologyRecoveryEnabled", topologyRecoveryEnabled);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * When true and an inOut Exchange failed on the consumer side send the
         * caused Exception back in the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRabbitMQEndpointBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
    }
    /**
     * RabbitMQ (camel-rabbitmq)
     * The rabbitmq component allows you produce and consume messages from
     * RabbitMQ instances.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-rabbitmq
     * 
     * Syntax: <code>rabbitmq:exchangeName</code>
     * 
     * Path parameter: exchangeName (required)
     * The exchange name determines which exchange produced messages will sent
     * to. In the case of consumers, the exchange name determines which exchange
     * the queue will bind to.
     */
    default RabbitMQEndpointBuilder rabbitmq(String path) {
        class RabbitMQEndpointBuilderImpl extends AbstractEndpointBuilder implements RabbitMQEndpointBuilder, AdvancedRabbitMQEndpointBuilder {
            public RabbitMQEndpointBuilderImpl(String path) {
                super("rabbitmq", path);
            }
        }
        return new RabbitMQEndpointBuilderImpl(path);
    }
}