/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The nats component allows you produce and consume messages from NATS.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface NatsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Nats component.
     */
    public interface NatsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedNatsEndpointConsumerBuilder advanced() {
            return (AdvancedNatsEndpointConsumerBuilder) this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option is a: <code>io.nats.client.Connection</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder connection(Object connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option will be converted to a
         * <code>io.nats.client.Connection</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder connection(String connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Define if we want to flush connection or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder flushConnection(
                boolean flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Define if we want to flush connection or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder flushConnection(
                String flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder flushTimeout(int flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder flushTimeout(String flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder maxPingsOut(int maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder maxPingsOut(String maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder maxReconnectAttempts(
                int maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder maxReconnectAttempts(
                String maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder noEcho(boolean noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder noEcho(String noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder noRandomizeServers(
                boolean noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder noRandomizeServers(
                String noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performace).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder pedantic(boolean pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performace).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder pedantic(String pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder pingInterval(int pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder pingInterval(String pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder reconnect(String reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder reconnectTimeWait(
                int reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder reconnectTimeWait(
                String reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder requestCleanupInterval(
                int requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder requestCleanupInterval(
                String requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * The name of topic we want to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default NatsEndpointConsumerBuilder topic(String topic) {
            doSetProperty("topic", topic);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder verbose(boolean verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointConsumerBuilder verbose(String verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default NatsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default NatsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Stop receiving messages from a topic we are subscribing to after
         * maxMessages.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default NatsEndpointConsumerBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Consumer pool size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default NatsEndpointConsumerBuilder poolSize(int poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * Consumer pool size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default NatsEndpointConsumerBuilder poolSize(String poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * The Queue name if we are using nats for a queue configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default NatsEndpointConsumerBuilder queueName(String queueName) {
            doSetProperty("queueName", queueName);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default NatsEndpointConsumerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default NatsEndpointConsumerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NatsEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NatsEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Nats component.
     */
    public interface AdvancedNatsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default NatsEndpointConsumerBuilder basic() {
            return (NatsEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedNatsEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedNatsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedNatsEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedNatsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Nats component.
     */
    public interface NatsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedNatsEndpointProducerBuilder advanced() {
            return (AdvancedNatsEndpointProducerBuilder) this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option is a: <code>io.nats.client.Connection</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder connection(Object connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option will be converted to a
         * <code>io.nats.client.Connection</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder connection(String connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Define if we want to flush connection or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder flushConnection(
                boolean flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Define if we want to flush connection or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder flushConnection(
                String flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder flushTimeout(int flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder flushTimeout(String flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder maxPingsOut(int maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder maxPingsOut(String maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder maxReconnectAttempts(
                int maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder maxReconnectAttempts(
                String maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder noEcho(boolean noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder noEcho(String noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder noRandomizeServers(
                boolean noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder noRandomizeServers(
                String noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performace).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder pedantic(boolean pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performace).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder pedantic(String pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder pingInterval(int pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder pingInterval(String pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder reconnect(String reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder reconnectTimeWait(
                int reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder reconnectTimeWait(
                String reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder requestCleanupInterval(
                int requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder requestCleanupInterval(
                String requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * The name of topic we want to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default NatsEndpointProducerBuilder topic(String topic) {
            doSetProperty("topic", topic);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder verbose(boolean verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointProducerBuilder verbose(String verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default NatsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default NatsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * the subject to which subscribers should send response.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default NatsEndpointProducerBuilder replySubject(String replySubject) {
            doSetProperty("replySubject", replySubject);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default NatsEndpointProducerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default NatsEndpointProducerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NatsEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NatsEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Nats component.
     */
    public interface AdvancedNatsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default NatsEndpointProducerBuilder basic() {
            return (NatsEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Nats component.
     */
    public interface NatsEndpointBuilder
            extends
                NatsEndpointConsumerBuilder, NatsEndpointProducerBuilder {
        default AdvancedNatsEndpointBuilder advanced() {
            return (AdvancedNatsEndpointBuilder) this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option is a: <code>io.nats.client.Connection</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder connection(Object connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Reference an already instantiated connection to Nats server.
         * 
         * The option will be converted to a
         * <code>io.nats.client.Connection</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder connection(String connection) {
            doSetProperty("connection", connection);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout for connection attempts. (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Define if we want to flush connection or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder flushConnection(boolean flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Define if we want to flush connection or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder flushConnection(String flushConnection) {
            doSetProperty("flushConnection", flushConnection);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder flushTimeout(int flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * Set the flush timeout (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder flushTimeout(String flushTimeout) {
            doSetProperty("flushTimeout", flushTimeout);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder maxPingsOut(int maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * maximum number of pings have not received a response allowed by the
         * client.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder maxPingsOut(String maxPingsOut) {
            doSetProperty("maxPingsOut", maxPingsOut);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder maxReconnectAttempts(
                int maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Max reconnection attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder maxReconnectAttempts(
                String maxReconnectAttempts) {
            doSetProperty("maxReconnectAttempts", maxReconnectAttempts);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder noEcho(boolean noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Turn off echo. If supported by the gnatsd version you are connecting
         * to this flag will prevent the server from echoing messages back to
         * the connection if it has subscriptions on the subject being published
         * to.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder noEcho(String noEcho) {
            doSetProperty("noEcho", noEcho);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder noRandomizeServers(
                boolean noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not randomizing the order of servers for the connection
         * attempts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder noRandomizeServers(String noRandomizeServers) {
            doSetProperty("noRandomizeServers", noRandomizeServers);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performace).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder pedantic(boolean pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Whether or not running in pedantic mode (this affects performace).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder pedantic(String pedantic) {
            doSetProperty("pedantic", pedantic);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder pingInterval(int pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Ping interval to be aware if connection is still alive (in
         * milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder pingInterval(String pingInterval) {
            doSetProperty("pingInterval", pingInterval);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder reconnect(boolean reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Whether or not using reconnection feature.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder reconnect(String reconnect) {
            doSetProperty("reconnect", reconnect);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder reconnectTimeWait(int reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Waiting time before attempts reconnection (in milliseconds).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder reconnectTimeWait(String reconnectTimeWait) {
            doSetProperty("reconnectTimeWait", reconnectTimeWait);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder requestCleanupInterval(
                int requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * Interval to clean up cancelled/timed out requests.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder requestCleanupInterval(
                String requestCleanupInterval) {
            doSetProperty("requestCleanupInterval", requestCleanupInterval);
            return this;
        }
        /**
         * The name of topic we want to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default NatsEndpointBuilder topic(String topic) {
            doSetProperty("topic", topic);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder verbose(boolean verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Whether or not running in verbose mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default NatsEndpointBuilder verbose(String verbose) {
            doSetProperty("verbose", verbose);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default NatsEndpointBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default NatsEndpointBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NatsEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NatsEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Nats component.
     */
    public interface AdvancedNatsEndpointBuilder
            extends
                AdvancedNatsEndpointConsumerBuilder, AdvancedNatsEndpointProducerBuilder {
        default NatsEndpointBuilder basic() {
            return (NatsEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedNatsEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Nats (camel-nats)
     * The nats component allows you produce and consume messages from NATS.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-nats
     * 
     * Syntax: <code>nats:servers</code>
     * 
     * Path parameter: servers (required)
     * URLs to one or more NAT servers. Use comma to separate URLs when
     * specifying multiple servers.
     */
    default NatsEndpointBuilder nats(String path) {
        class NatsEndpointBuilderImpl extends AbstractEndpointBuilder implements NatsEndpointBuilder, AdvancedNatsEndpointBuilder {
            public NatsEndpointBuilderImpl(String path) {
                super("nats", path);
            }
        }
        return new NatsEndpointBuilderImpl(path);
    }
}