/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.hdfs.DefaultHdfsFileType;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.Holder;
import org.apache.camel.util.IOHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;

class HdfsNormalFileType
extends DefaultHdfsFileType {
    HdfsNormalFileType() {
    }

    @Override
    public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
        long l;
        InputStream is = null;
        try {
            is = (InputStream)typeConverter.convertTo(InputStream.class, value);
            l = this.copyBytes(is, (OutputStream)((FSDataOutputStream)hdfsostr.getOut()), 4096, false);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeCamelException((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOHelper.close(is);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)is);
        return l;
    }

    @Override
    public long next(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(hdfsInputStream.getChunkSize());
            byte[] buf = new byte[hdfsInputStream.getChunkSize()];
            int bytesRead = ((InputStream)hdfsInputStream.getIn()).read(buf);
            if (bytesRead >= 0) {
                bos.write(buf, 0, bytesRead);
                key.value = null;
                value.value = bos;
                return bytesRead;
            }
            key.value = null;
            value.value = bos;
            return 0L;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
        try {
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfo(hdfsPath, configuration);
            FSDataOutputStream rout = !configuration.isAppend() ? hdfsInfo.getFileSystem().create(hdfsInfo.getPath(), configuration.isOverwrite(), configuration.getBufferSize(), configuration.getReplication(), configuration.getBlockSize(), () -> {}) : hdfsInfo.getFileSystem().append(hdfsInfo.getPath(), configuration.getBufferSize(), () -> {});
            return rout;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
        try {
            FileInputStream rin;
            if (configuration.getFileSystemType().equals((Object)HdfsFileSystemType.LOCAL)) {
                HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfo(hdfsPath, configuration);
                rin = hdfsInfo.getFileSystem().open(hdfsInfo.getPath());
            } else {
                rin = new FileInputStream(this.getHfdsFileToTmpFile(hdfsPath, configuration));
            }
            return rin;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    private File getHfdsFileToTmpFile(String hdfsPath, HdfsConfiguration configuration) {
        try {
            File outputDest;
            String fname = hdfsPath.substring(hdfsPath.lastIndexOf(47));
            try {
                outputDest = Files.createTempFile(fname, ".hdfs", new FileAttribute[0]).toFile();
            }
            catch (Exception ex) {
                outputDest = File.createTempFile(fname, ".hdfs");
            }
            if (outputDest.exists()) {
                outputDest.delete();
            }
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfo(hdfsPath, configuration);
            FileSystem fileSystem = hdfsInfo.getFileSystem();
            FileUtil.copy((FileSystem)fileSystem, (Path)new Path(hdfsPath), (File)outputDest, (boolean)false, (Configuration)fileSystem.getConf());
            try {
                FileUtil.copyMerge((FileSystem)fileSystem, (Path)new Path(hdfsPath), (FileSystem)FileSystem.getLocal((Configuration)new Configuration()), (Path)new Path(outputDest.toURI()), (boolean)false, (Configuration)fileSystem.getConf(), null);
            }
            catch (IOException e) {
                return outputDest;
            }
            return new File(outputDest, fname);
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }
}

