/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.camel.component.hdfs.HaConfigurationBuilder;
import org.apache.camel.component.hdfs.HdfsComponent;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.kerberos.KerberosAuthentication;
import org.apache.camel.component.hdfs.kerberos.KerberosConfigurationBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class HdfsInfoFactory {
    private HdfsInfoFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsInfo newHdfsInfo(String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        javax.security.auth.login.Configuration auth = HdfsComponent.getJAASConfiguration();
        try {
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfoWithoutAuth(hdfsPath, endpointConfig);
            return hdfsInfo;
        }
        finally {
            HdfsComponent.setJAASConfiguration(auth);
        }
    }

    static HdfsInfo newHdfsInfoWithoutAuth(String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        Configuration configuration = HdfsInfoFactory.newConfiguration(endpointConfig);
        HdfsInfoFactory.authenticate(configuration, endpointConfig);
        FileSystem fileSystem = HdfsInfoFactory.newFileSystem(configuration, hdfsPath, endpointConfig);
        Path path = new Path(hdfsPath);
        return new HdfsInfo(configuration, fileSystem, path);
    }

    static Configuration newConfiguration(HdfsConfiguration endpointConfig) {
        Configuration configuration = new Configuration();
        if (endpointConfig.isKerberosAuthentication()) {
            KerberosConfigurationBuilder.withKerberosConfiguration(configuration, endpointConfig);
        }
        if (endpointConfig.hasClusterConfiguration()) {
            HaConfigurationBuilder.withClusterConfiguration(configuration, endpointConfig);
        }
        return configuration;
    }

    static void authenticate(Configuration configuration, HdfsConfiguration endpointConfig) throws IOException {
        if (endpointConfig.isKerberosAuthentication()) {
            String userName = endpointConfig.getKerberosUsername();
            String keytabLocation = endpointConfig.getKerberosKeytabLocation();
            new KerberosAuthentication(configuration, userName, keytabLocation).loginWithKeytab();
        }
    }

    static FileSystem newFileSystem(Configuration configuration, String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        FileSystem fileSystem = endpointConfig.hasClusterConfiguration() ? FileSystem.get((Configuration)configuration) : FileSystem.get((URI)URI.create(hdfsPath), (Configuration)configuration);
        return fileSystem;
    }
}

