/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.Closeable;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.hdfs.HdfsArrayFileType;
import org.apache.camel.component.hdfs.HdfsBloommapFileType;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFile;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsMapFileType;
import org.apache.camel.component.hdfs.HdfsNormalFileType;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.HdfsSequenceFileType;
import org.apache.camel.component.hdfs.Holder;

public enum HdfsFileType {
    NORMAL_FILE(new HdfsNormalFileType()),
    SEQUENCE_FILE(new HdfsSequenceFileType()),
    MAP_FILE(new HdfsMapFileType()),
    BLOOMMAP_FILE(new HdfsBloommapFileType()),
    ARRAY_FILE(new HdfsArrayFileType());

    private final HdfsFile file;

    private HdfsFileType(HdfsFile file) {
        this.file = file;
    }

    public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
        return this.file.append(hdfsostr, key, value, typeConverter);
    }

    public long next(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        return this.file.next(hdfsInputStream, key, value);
    }

    public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
        return this.file.createOutputStream(hdfsPath, configuration);
    }

    public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
        return this.file.createInputStream(hdfsPath, configuration);
    }
}

