/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.paho.PahoEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class PahoProducer
extends DefaultProducer {
    private volatile MqttClient client;
    private volatile String clientId;
    private volatile boolean stopClient;
    private volatile MqttConnectOptions connectOptions;

    public PahoProducer(PahoEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        String topic = (String)exchange.getIn().getHeader("CamelPahoOverrideTopic", (Object)this.getEndpoint().getTopic(), String.class);
        int qos = (Integer)exchange.getIn().getHeader("CamelPahoQos", (Object)this.getEndpoint().getConfiguration().getQos(), Integer.class);
        boolean retained = (Boolean)exchange.getIn().getHeader("CamelPahoRetained", (Object)this.getEndpoint().getConfiguration().isRetained(), Boolean.class);
        byte[] payload = (byte[])exchange.getIn().getBody(byte[].class);
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        this.log.debug("Publishing to topic: {}, qos: {}, retrained: {}", new Object[]{topic, qos, retained});
        this.client.publish(topic, message);
    }

    public PahoEndpoint getEndpoint() {
        return (PahoEndpoint)super.getEndpoint();
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connectOptions = PahoEndpoint.createMqttConnectOptions(this.getEndpoint().getConfiguration());
        if (this.client == null) {
            this.clientId = this.getEndpoint().getConfiguration().getClientId();
            if (this.clientId == null) {
                this.clientId = "camel-" + MqttClient.generateClientId();
            }
            this.stopClient = true;
            this.client = new MqttClient(this.getEndpoint().getConfiguration().getBrokerUrl(), this.clientId, PahoEndpoint.createMqttClientPersistence(this.getEndpoint().getConfiguration()));
            this.log.debug("Connecting client: {} to broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.connect(this.connectOptions);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.stopClient && this.client != null && this.client.isConnected()) {
            this.log.debug("Disconnecting client: {} from broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.disconnect();
            this.client = null;
        }
    }
}

