/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonObject;
import java.net.URI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbComponent;
import org.apache.camel.component.couchdb.CouchDbConsumer;
import org.apache.camel.component.couchdb.CouchDbProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.lightcouch.CouchDbClient;

@UriEndpoint(firstVersion="2.11.0", scheme="couchdb", title="CouchDB", syntax="couchdb:protocol:hostname:port/database", label="database,nosql")
public class CouchDbEndpoint
extends DefaultEndpoint {
    public static final String DEFAULT_STYLE = "main_only";
    public static final long DEFAULT_HEARTBEAT = 30000L;
    public static final int DEFAULT_PORT = 5984;
    private static final String URI_ERROR = "Invalid URI. Format must be of the form couchdb:http[s]://hostname[:port]/database?[options...]";
    @UriPath(enums="http,https")
    @Metadata(required=true)
    private String protocol;
    @UriPath
    @Metadata(required=true)
    private String hostname;
    @UriPath(defaultValue="5984")
    private int port;
    @UriPath
    @Metadata(required=true)
    private String database;
    @UriParam(label="consumer", enums="all_docs,main_only", defaultValue="main_only")
    private String style = "main_only";
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="consumer", defaultValue="30000")
    private long heartbeat = 30000L;
    @UriParam
    private boolean createDatabase;
    @UriParam(label="consumer", defaultValue="true")
    private boolean deletes = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean updates = true;
    @UriParam(label="consumer")
    private String since;

    public CouchDbEndpoint() {
    }

    public CouchDbEndpoint(String endpointUri, String remaining, CouchDbComponent component) throws Exception {
        super(endpointUri, (Component)component);
        URI uri = new URI(remaining);
        this.protocol = uri.getScheme();
        if (this.protocol == null) {
            throw new IllegalArgumentException(URI_ERROR);
        }
        int n = this.port = uri.getPort() == -1 ? 5984 : uri.getPort();
        if (uri.getPath() == null || uri.getPath().trim().length() == 0) {
            throw new IllegalArgumentException(URI_ERROR);
        }
        this.database = uri.getPath().substring(1);
        this.hostname = uri.getHost();
        if (this.hostname == null) {
            throw new IllegalArgumentException(URI_ERROR);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CouchDbConsumer answer = new CouchDbConsumer(this, this.createClient(), processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new CouchDbProducer(this, this.createClient());
    }

    public Exchange createExchange(String seq, String id, JsonObject obj, boolean deleted) {
        Exchange exchange = super.createExchange();
        exchange.getIn().setHeader("CouchDbDatabase", (Object)this.database);
        exchange.getIn().setHeader("CouchDbSeq", (Object)seq);
        exchange.getIn().setHeader("CouchDbId", (Object)id);
        exchange.getIn().setHeader("CouchDbRev", (Object)obj.get("_rev").getAsString());
        exchange.getIn().setHeader("CouchDbMethod", (Object)(deleted ? "DELETE" : "UPDATE"));
        exchange.getIn().setBody((Object)obj);
        return exchange;
    }

    protected CouchDbClientWrapper createClient() {
        return new CouchDbClientWrapper(new CouchDbClient(this.database, this.createDatabase, this.protocol, this.hostname, this.port, this.username, this.password));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(long heartbeat) {
        this.heartbeat = heartbeat;
    }

    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.createDatabase = createDatabase;
    }

    public boolean isDeletes() {
        return this.deletes;
    }

    public void setDeletes(boolean deletes) {
        this.deletes = deletes;
    }

    public boolean isUpdates() {
        return this.updates;
    }

    public void setUpdates(boolean updates) {
        this.updates = updates;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }
}

