/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import com.twilio.type.PhoneNumber;
import com.twilio.type.Sip;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.twilio.TwilioConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class TwilioConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        TwilioConverterLoader.addTypeConverter(registry, PhoneNumber.class, String.class, false, (type, exchange, value) -> TwilioConverter.toPhoneNumber((String)value));
        TwilioConverterLoader.addTypeConverter(registry, Sip.class, String.class, false, (type, exchange, value) -> TwilioConverter.toSip((String)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

