/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class OsgiCamelContextPublisher
extends EventNotifierSupport {
    public static final String CONTEXT_SYMBOLIC_NAME_PROPERTY = "camel.context.symbolicname";
    public static final String CONTEXT_VERSION_PROPERTY = "camel.context.version";
    public static final String CONTEXT_NAME_PROPERTY = "camel.context.name";
    public static final String CONTEXT_MANAGEMENT_NAME_PROPERTY = "camel.context.managementname";
    private final BundleContext bundleContext;
    private final Map<CamelContext, ServiceRegistration<?>> registrations = new ConcurrentHashMap();

    public OsgiCamelContextPublisher(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void notify(CamelEvent event) throws Exception {
        CamelContext context;
        ServiceRegistration<?> reg;
        if (event.getType() == CamelEvent.Type.CamelContextStarted) {
            CamelContext context2 = ((CamelEvent.CamelContextEvent)event).getContext();
            this.registerCamelContext(context2);
        } else if (event.getType() == CamelEvent.Type.CamelContextStopping && (reg = this.registrations.remove(context = ((CamelEvent.CamelContextEvent)event).getContext())) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistering CamelContext [{}] from OSGi registry", (Object)context.getName());
            }
            try {
                reg.unregister();
            }
            catch (Exception e) {
                this.log.warn("Error unregistering CamelContext [" + context.getName() + "] from OSGi registry. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public boolean isEnabled(CamelEvent event) {
        return event.getType() == CamelEvent.Type.CamelContextStarted || event.getType() == CamelEvent.Type.CamelContextStopping;
    }

    protected void doShutdown() throws Exception {
        if (!this.registrations.isEmpty()) {
            this.log.warn("On shutdown there are {} registrations which was supposed to have been unregistered already. Will unregister these now.", (Object)this.registrations.size());
            for (ServiceRegistration<?> reg : this.registrations.values()) {
                try {
                    reg.unregister();
                }
                catch (Exception e) {
                    this.log.warn("Error unregistering from OSGi registry. This exception will be ignored.", (Throwable)e);
                }
            }
        }
        this.registrations.clear();
    }

    public ServiceRegistration<?> registerCamelContext(CamelContext camelContext) throws InvalidSyntaxException {
        String name = camelContext.getName();
        String managementName = camelContext.getManagementName();
        String symbolicName = this.bundleContext.getBundle().getSymbolicName();
        if (!OsgiCamelContextPublisher.lookupCamelContext(this.bundleContext, symbolicName, name)) {
            Version bundleVersion = OsgiCamelContextPublisher.getBundleVersion(this.bundleContext.getBundle());
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(CONTEXT_SYMBOLIC_NAME_PROPERTY, symbolicName);
            ((Dictionary)props).put(CONTEXT_VERSION_PROPERTY, (String)bundleVersion);
            ((Dictionary)props).put(CONTEXT_NAME_PROPERTY, name);
            if (managementName != null) {
                ((Dictionary)props).put(CONTEXT_MANAGEMENT_NAME_PROPERTY, managementName);
            }
            this.log.debug("Registering CamelContext [{}] in OSGi registry", (Object)name);
            ServiceRegistration reg = this.bundleContext.registerService(CamelContext.class.getName(), (Object)camelContext, props);
            if (reg != null) {
                this.registrations.put(camelContext, reg);
            }
            return reg;
        }
        return null;
    }

    public static Version getBundleVersion(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
    }

    public static boolean lookupCamelContext(BundleContext bundleContext, String symbolicName, String contextName) throws InvalidSyntaxException {
        Version bundleVersion = OsgiCamelContextPublisher.getBundleVersion(bundleContext.getBundle());
        ServiceReference[] refs = bundleContext.getServiceReferences(CamelContext.class.getName(), "(&(camel.context.symbolicname=" + symbolicName + ")(" + CONTEXT_NAME_PROPERTY + "=" + contextName + ")(" + CONTEXT_VERSION_PROPERTY + "=" + bundleVersion + "))");
        return refs != null && refs.length > 0;
    }
}

