/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarProducer;
import org.apache.camel.component.pulsar.configuration.PulsarConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.pulsar.client.api.PulsarClient;

@UriEndpoint(scheme="pulsar", firstVersion="2.24.0", title="Apache Pulsar", syntax="pulsar:persistence://tenant/namespace/topic", label="messaging")
public class PulsarEndpoint
extends DefaultEndpoint {
    private PulsarClient pulsarClient;
    private String uri;
    @UriPath(enums="persistent,non-persistent")
    @Metadata(required=true)
    private String persistence;
    @UriPath
    @Metadata(required=true)
    private String tenant;
    @UriPath
    @Metadata(required=true)
    private String namespace;
    @UriPath
    @Metadata(required=true)
    private String topic;
    @UriParam
    private PulsarConfiguration pulsarConfiguration;

    public PulsarEndpoint(String uri, PulsarComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() {
        return new PulsarProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        PulsarConsumer consumer = new PulsarConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PulsarClient getPulsarClient() {
        return this.pulsarClient;
    }

    public void setPulsarClient(PulsarClient pulsarClient) {
        this.pulsarClient = pulsarClient;
    }

    public String getPersistence() {
        return this.persistence;
    }

    public void setPersistence(String persistence) {
        this.persistence = persistence;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public PulsarConfiguration getPulsarConfiguration() {
        return this.pulsarConfiguration;
    }

    public void setPulsarConfiguration(PulsarConfiguration pulsarConfiguration) {
        this.pulsarConfiguration = pulsarConfiguration;
    }

    public String getUri() {
        return this.persistence + "://" + this.tenant + "/" + this.namespace + "/" + this.topic;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.persistence, (String)"persistence", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.tenant, (String)"tenant", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.namespace, (String)"namespace", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.topic, (String)"topic", (Object)((Object)this));
        this.uri = this.persistence + "://" + this.tenant + "/" + this.namespace + "/" + this.topic;
    }

    public PulsarComponent getComponent() {
        return (PulsarComponent)super.getComponent();
    }
}

