/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.PulsarUtils;
import org.apache.camel.component.pulsar.utils.consumers.ConsumerCreationStrategy;
import org.apache.camel.component.pulsar.utils.consumers.ConsumerCreationStrategyFactory;
import org.apache.camel.support.DefaultConsumer;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.PulsarClientException;

public class PulsarConsumer
extends DefaultConsumer {
    private final PulsarEndpoint pulsarEndpoint;
    private final ConsumerCreationStrategyFactory consumerCreationStrategyFactory;
    private Queue<Consumer<byte[]>> pulsarConsumers;

    public PulsarConsumer(PulsarEndpoint pulsarEndpoint, Processor processor) {
        super((Endpoint)pulsarEndpoint, processor);
        this.pulsarEndpoint = pulsarEndpoint;
        this.pulsarConsumers = new ConcurrentLinkedQueue<Consumer<byte[]>>();
        this.consumerCreationStrategyFactory = ConsumerCreationStrategyFactory.create(this);
    }

    protected void doStart() throws Exception {
        this.pulsarConsumers = PulsarUtils.stopConsumers(this.pulsarConsumers);
        Collection<Consumer<byte[]>> consumers = this.createConsumers(this.pulsarEndpoint, this.consumerCreationStrategyFactory);
        this.pulsarConsumers.addAll(consumers);
    }

    protected void doStop() throws PulsarClientException {
        this.pulsarConsumers = PulsarUtils.stopConsumers(this.pulsarConsumers);
    }

    protected void doSuspend() throws PulsarClientException {
        this.pulsarConsumers = PulsarUtils.stopConsumers(this.pulsarConsumers);
    }

    protected void doResume() throws Exception {
        this.pulsarConsumers = PulsarUtils.stopConsumers(this.pulsarConsumers);
        Collection<Consumer<byte[]>> consumers = this.createConsumers(this.pulsarEndpoint, this.consumerCreationStrategyFactory);
        this.pulsarConsumers.addAll(consumers);
    }

    private Collection<Consumer<byte[]>> createConsumers(PulsarEndpoint endpoint, ConsumerCreationStrategyFactory factory) throws Exception {
        ConsumerCreationStrategy strategy = factory.getStrategy(endpoint.getPulsarConfiguration().getSubscriptionType());
        return strategy.create(endpoint);
    }
}

