/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return RedisEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return RedisEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "command": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setCommand((Command)((Object)RedisEndpointConfigurer.property((CamelContext)camelContext, Command.class, (Object)value)));
                return true;
            }
            case "channels": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setChannels((String)RedisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "redisTemplate": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setRedisTemplate((RedisTemplate)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisTemplate.class, (Object)value));
                return true;
            }
            case "listenerContainer": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setListenerContainer((RedisMessageListenerContainer)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisMessageListenerContainer.class, (Object)value));
                return true;
            }
            case "connectionFactory": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setConnectionFactory((RedisConnectionFactory)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisConnectionFactory.class, (Object)value));
                return true;
            }
            case "serializer": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setSerializer((RedisSerializer)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisSerializer.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((RedisEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((RedisEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((RedisEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)RedisEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((RedisEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)RedisEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((RedisEndpoint)((Object)endpoint)).setSynchronous((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((RedisEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "command": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setCommand((Command)((Object)RedisEndpointConfigurer.property((CamelContext)camelContext, Command.class, (Object)value)));
                return true;
            }
            case "channels": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setChannels((String)RedisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "redistemplate": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setRedisTemplate((RedisTemplate)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisTemplate.class, (Object)value));
                return true;
            }
            case "listenercontainer": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setListenerContainer((RedisMessageListenerContainer)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisMessageListenerContainer.class, (Object)value));
                return true;
            }
            case "connectionfactory": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setConnectionFactory((RedisConnectionFactory)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisConnectionFactory.class, (Object)value));
                return true;
            }
            case "serializer": {
                ((RedisEndpoint)((Object)endpoint)).getConfiguration().setSerializer((RedisSerializer)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisSerializer.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((RedisEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((RedisEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((RedisEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)RedisEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((RedisEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)RedisEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((RedisEndpoint)((Object)endpoint)).setSynchronous((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((RedisEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

