/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PubNubException;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.api.models.consumer.presence.PNWhereNowResult;
import java.util.Arrays;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;

public class PubNubProducer
extends DefaultAsyncProducer {
    private final PubNubEndpoint endpoint;
    private final PubNubConfiguration pubnubConfiguration;

    public PubNubProducer(PubNubEndpoint endpoint, PubNubConfiguration pubNubConfiguration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.pubnubConfiguration = pubNubConfiguration;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Operation operation = this.getOperation(exchange);
        this.log.debug("Executing {} operation", (Object)operation);
        try {
            switch (operation) {
                case PUBLISH: {
                    this.doPublish(exchange, callback);
                    break;
                }
                case FIRE: {
                    this.doFire(exchange, callback);
                    break;
                }
                case GETHISTORY: {
                    this.doGetHistory(exchange, callback);
                    break;
                }
                case GETSTATE: {
                    this.doGetState(exchange, callback);
                    break;
                }
                case HERENOW: {
                    this.doHereNow(exchange, callback);
                    break;
                }
                case SETSTATE: {
                    this.doSetState(exchange, callback);
                    break;
                }
                case WHERENOW: {
                    this.doWhereNow(exchange, callback);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(operation.toString());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    private void doPublish(final Exchange exchange, final AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            throw new RuntimeException("Can not publish empty message");
        }
        this.log.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().publish().message(body).channel(this.getChannel(exchange)).usePOST(Boolean.valueOf(true)).async((PNCallback)new PNCallback<PNPublishResult>(){

            public void onResponse(PNPublishResult result, PNStatus status) {
                if (!status.isError()) {
                    exchange.getIn().setHeader("CamelPubNubTimeToken", (Object)result.getTimetoken());
                }
                PubNubProducer.this.processMessage(exchange, callback, status, null);
            }
        });
    }

    private void doFire(final Exchange exchange, final AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            exchange.setException((Throwable)new CamelException("Can not fire empty message"));
            callback.done(true);
        }
        this.log.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().fire().message(body).channel(this.getChannel(exchange)).async((PNCallback)new PNCallback<PNPublishResult>(){

            public void onResponse(PNPublishResult result, PNStatus status) {
                if (!status.isError()) {
                    exchange.getIn().setHeader("CamelPubNubTimeToken", (Object)result.getTimetoken());
                }
                PubNubProducer.this.processMessage(exchange, callback, status, null);
            }
        });
    }

    private void doGetHistory(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().history().channel(this.getChannel(exchange)).async((PNCallback)new PNCallback<PNHistoryResult>(){

            public void onResponse(PNHistoryResult result, PNStatus status) {
                PubNubProducer.this.log.debug("Got history message [{}]", (Object)result);
                PubNubProducer.this.processMessage(exchange, callback, status, result.getMessages());
            }
        });
    }

    private void doSetState(final Exchange exchange, final AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            exchange.setException((Throwable)new CamelException("Can not publish empty message"));
            callback.done(true);
        }
        this.log.debug("Sending setState [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().setPresenceState().channels(Arrays.asList(this.getChannel(exchange))).state(body).uuid(this.getUUID(exchange)).async((PNCallback)new PNCallback<PNSetStateResult>(){

            public void onResponse(PNSetStateResult result, PNStatus status) {
                PubNubProducer.this.log.debug("Got setState responsee [{}]", (Object)result);
                PubNubProducer.this.processMessage(exchange, callback, status, result);
            }
        });
    }

    private void doGetState(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().getPresenceState().channels(Arrays.asList(this.getChannel(exchange))).uuid(this.getUUID(exchange)).async((PNCallback)new PNCallback<PNGetStateResult>(){

            public void onResponse(PNGetStateResult result, PNStatus status) {
                PubNubProducer.this.log.debug("Got state [{}]", (Object)result.getStateByUUID());
                PubNubProducer.this.processMessage(exchange, callback, status, result);
            }
        });
    }

    private void doHereNow(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().hereNow().channels(Arrays.asList(this.getChannel(exchange))).includeState(Boolean.valueOf(true)).includeUUIDs(Boolean.valueOf(true)).async((PNCallback)new PNCallback<PNHereNowResult>(){

            public void onResponse(PNHereNowResult result, PNStatus status) {
                PubNubProducer.this.log.debug("Got herNow message [{}]", (Object)result);
                PubNubProducer.this.processMessage(exchange, callback, status, result);
            }
        });
    }

    private void doWhereNow(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().whereNow().uuid(this.getUUID(exchange)).async((PNCallback)new PNCallback<PNWhereNowResult>(){

            public void onResponse(PNWhereNowResult result, PNStatus status) {
                PubNubProducer.this.log.debug("Got whereNow message [{}]", (Object)result.getChannels());
                PubNubProducer.this.processMessage(exchange, callback, status, result.getChannels());
            }
        });
    }

    private void processMessage(Exchange exchange, AsyncCallback callback, PNStatus status, Object body) {
        if (status.isError()) {
            PNErrorData errorData = status.getErrorData();
            exchange.setException((Throwable)errorData.getThrowable());
            if (errorData != null && errorData.getThrowable() instanceof PubNubException) {
                PubNubException pubNubException = (PubNubException)errorData.getThrowable();
                throw new RuntimeException(pubNubException.getPubnubError().getMessage(), errorData.getThrowable());
            }
            throw new RuntimeException(status.getErrorData().getThrowable());
        }
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(body);
        } else {
            exchange.getIn().setBody(body);
        }
        callback.done(false);
    }

    private Operation getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("CamelPubNubOperation", String.class);
        if (operation == null) {
            operation = this.pubnubConfiguration.getOperation();
        }
        return operation != null ? Operation.valueOf(operation.toUpperCase()) : Operation.PUBLISH;
    }

    private String getChannel(Exchange exchange) {
        String channel = (String)exchange.getIn().getHeader("CamelPubNubChannel", String.class);
        return channel != null ? channel : this.pubnubConfiguration.getChannel();
    }

    private String getUUID(Exchange exchange) {
        String uuid = (String)exchange.getIn().getHeader("CamelPubNubUUID", String.class);
        return uuid != null ? uuid : this.pubnubConfiguration.getUuid();
    }

    private static enum Operation {
        HERENOW,
        WHERENOW,
        GETSTATE,
        SETSTATE,
        GETHISTORY,
        PUBLISH,
        FIRE;

    }
}

