/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.tika.TikaConfiguration;
import org.apache.camel.component.tika.TikaProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="tika", title="Tika", syntax="tika:operation", producerOnly=true, label="document,transformation")
public class TikaEndpoint
extends DefaultEndpoint {
    @UriParam
    private TikaConfiguration tikaConfiguration;

    public TikaEndpoint(String endpointUri, Component component, TikaConfiguration tikaConfiguration) {
        super(endpointUri, component);
        this.tikaConfiguration = tikaConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new TikaProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer does not supported for Tika component:" + this.getEndpointUri());
    }

    public TikaConfiguration getTikaConfiguration() {
        return this.tikaConfiguration;
    }

    public void setTikaConfiguration(TikaConfiguration tikaConfiguration) {
        this.tikaConfiguration = tikaConfiguration;
    }
}

