/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.support.ExchangeHelper;

public final class BeanstalkExchangeHelper {
    private BeanstalkExchangeHelper() {
    }

    public static long getPriority(BeanstalkEndpoint endpoint, Message in) {
        return (Long)in.getHeader("beanstalk.priority", (Object)endpoint.getJobPriority(), Long.class);
    }

    public static int getDelay(BeanstalkEndpoint endpoint, Message in) {
        return (Integer)in.getHeader("beanstalk.delay", (Object)endpoint.getJobDelay(), Integer.class);
    }

    public static int getTimeToRun(BeanstalkEndpoint endpoint, Message in) {
        return (Integer)in.getHeader("beanstalk.timeToRun", (Object)endpoint.getJobTimeToRun(), Integer.class);
    }

    public static long getJobID(Exchange exchange) throws NoSuchHeaderException {
        return (Long)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"beanstalk.jobId", Long.class);
    }
}

