/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.model.validator.CustomValidatorDefinition;
import org.apache.camel.model.validator.EndpointValidatorDefinition;
import org.apache.camel.model.validator.PredicateValidatorDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.reifier.validator.CustomValidatorReifier;
import org.apache.camel.reifier.validator.EndpointValidatorReifier;
import org.apache.camel.reifier.validator.PredicateValidatorReifier;
import org.apache.camel.spi.Validator;

public abstract class ValidatorReifier<T> {
    private static final Map<Class<?>, Function<ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>>> VALIDATORS;
    protected final T definition;

    public ValidatorReifier(T definition) {
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, Function<ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>> creator) {
        VALIDATORS.put(processorClass, creator);
    }

    public static ValidatorReifier<? extends ValidatorDefinition> reifier(ValidatorDefinition definition) {
        Function<ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>> reifier = VALIDATORS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(definition);
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public Validator createValidator(CamelContext context) throws Exception {
        return this.doCreateValidator(context);
    }

    protected abstract Validator doCreateValidator(CamelContext var1) throws Exception;

    static {
        HashMap map = new HashMap();
        map.put(CustomValidatorDefinition.class, CustomValidatorReifier::new);
        map.put(EndpointValidatorDefinition.class, EndpointValidatorReifier::new);
        map.put(PredicateValidatorDefinition.class, PredicateValidatorReifier::new);
        VALIDATORS = map;
    }
}

