/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.loadbalancer;

import java.util.ArrayList;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRoundRobinLoadBalancer;
import org.apache.camel.reifier.loadbalancer.LoadBalancerReifier;
import org.apache.camel.spi.RouteContext;

public class WeightedLoadBalancerReifier
extends LoadBalancerReifier<WeightedLoadBalancerDefinition> {
    public WeightedLoadBalancerReifier(LoadBalancerDefinition definition) {
        super((WeightedLoadBalancerDefinition)definition);
    }

    @Override
    public LoadBalancer createLoadBalancer(RouteContext routeContext) {
        Object loadBalancer;
        ArrayList<Integer> distributionRatioList = new ArrayList<Integer>();
        try {
            boolean isRoundRobin;
            String[] ratios;
            for (String ratio : ratios = ((WeightedLoadBalancerDefinition)this.definition).getDistributionRatio().split(((WeightedLoadBalancerDefinition)this.definition).getDistributionRatioDelimiter())) {
                distributionRatioList.add(Integer.parseInt(ratio.trim()));
            }
            boolean bl = isRoundRobin = ((WeightedLoadBalancerDefinition)this.definition).getRoundRobin() != null && ((WeightedLoadBalancerDefinition)this.definition).getRoundRobin() != false;
            loadBalancer = isRoundRobin ? new WeightedRoundRobinLoadBalancer(distributionRatioList) : new WeightedRandomLoadBalancer(distributionRatioList);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return loadBalancer;
    }
}

