/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.processor.ContractAdvice;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.rest.RestBindingReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Contract;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class RouteReifier
extends ProcessorReifier<RouteDefinition> {
    public RouteReifier(ProcessorDefinition<?> definition) {
        super((RouteDefinition)definition);
    }

    public static RouteDefinition adviceWith(RouteDefinition definition, CamelContext camelContext, RouteBuilder builder) throws Exception {
        ObjectHelper.notNull((Object)definition, (String)"RouteDefinition");
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        ObjectHelper.notNull((Object)builder, (String)"RouteBuilder");
        if (definition.getInput() == null) {
            throw new IllegalArgumentException("RouteDefinition has no input");
        }
        return new RouteReifier(definition).adviceWith(camelContext, builder);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new UnsupportedOperationException("Not implemented for RouteDefinition");
    }

    public Route createRoute(CamelContext camelContext, RouteContext routeContext) {
        try {
            return this.doCreateRoute(camelContext, routeContext);
        }
        catch (FailedToCreateRouteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), (Throwable)e);
        }
    }

    public Endpoint resolveEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        return CamelContextHelper.getMandatoryEndpoint((CamelContext)camelContext, (String)uri);
    }

    public RouteDefinition adviceWith(CamelContext camelContext, RouteBuilder builder) throws Exception {
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        ObjectHelper.notNull((Object)builder, (String)"RouteBuilder");
        this.log.debug("AdviceWith route before: {}", (Object)this);
        boolean logRoutesAsXml = true;
        if (builder instanceof AdviceWithRouteBuilder) {
            AdviceWithRouteBuilder arb = (AdviceWithRouteBuilder)builder;
            arb.setOriginalRoute((RouteDefinition)this.definition);
            logRoutesAsXml = arb.isLogRouteAsXml();
        }
        RoutesDefinition routes = builder.configureRoutes(camelContext);
        this.log.debug("AdviceWith routes: {}", (Object)routes);
        if (!builder.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.");
        }
        if (builder.getRouteCollection().getErrorHandlerFactory() != null && ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory() != builder.getRouteCollection().getErrorHandlerFactory()) {
            throw new IllegalArgumentException("You can not advice with error handlers. Remove the error handlers from the route builder.");
        }
        String beforeAsXml = null;
        if (logRoutesAsXml && this.log.isInfoEnabled()) {
            beforeAsXml = ModelHelper.dumpModelAsXml(camelContext, this.definition);
        }
        ((Model)camelContext.getExtension(Model.class)).removeRouteDefinition((RouteDefinition)this.definition);
        if (builder instanceof AdviceWithRouteBuilder) {
            List<AdviceWithTask> tasks = ((AdviceWithRouteBuilder)builder).getAdviceWithTasks();
            for (AdviceWithTask task : tasks) {
                task.task();
            }
        }
        RouteDefinition merged = routes.route((RouteDefinition)this.definition);
        ((Model)camelContext.getExtension(Model.class)).getRouteDefinitions().add(0, merged);
        if (this.log.isInfoEnabled()) {
            this.log.info("AdviceWith route after: {}", (Object)merged);
        }
        if (logRoutesAsXml && this.log.isInfoEnabled()) {
            String afterAsXml = ModelHelper.dumpModelAsXml(camelContext, merged);
            this.log.info("Adviced route before/after as XML:\n{}\n{}", (Object)beforeAsXml, (Object)afterAsXml);
        }
        if (camelContext.isStarted()) {
            ((Model)camelContext.getExtension(Model.class)).addRouteDefinition(merged);
        }
        return merged;
    }

    protected Route doCreateRoute(CamelContext camelContext, RouteContext routeContext) throws Exception {
        Boolean isAutoStartup;
        RoutePolicy policy;
        Object delayer;
        Boolean isStreamCache;
        Boolean isLogMask;
        Boolean isMessageHistory;
        Boolean isTrace;
        routeContext.setErrorHandlerFactory(((RouteDefinition)this.definition).getErrorHandlerFactory());
        if (((RouteDefinition)this.definition).getTrace() != null && (isTrace = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getTrace())) != null) {
            routeContext.setTracing(isTrace);
            if (isTrace.booleanValue()) {
                this.log.debug("Tracing is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getMessageHistory() != null && (isMessageHistory = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getMessageHistory())) != null) {
            routeContext.setMessageHistory(isMessageHistory);
            if (isMessageHistory.booleanValue()) {
                this.log.debug("Message history is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getLogMask() != null && (isLogMask = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getLogMask())) != null) {
            routeContext.setLogMask(isLogMask);
            if (isLogMask.booleanValue()) {
                this.log.debug("Security mask for Logging is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getStreamCache() != null && (isStreamCache = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getStreamCache())) != null) {
            routeContext.setStreamCaching(isStreamCache);
            if (isStreamCache.booleanValue()) {
                this.log.debug("StreamCaching is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getDelayer() != null && (delayer = CamelContextHelper.parseLong((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getDelayer())) != null) {
            routeContext.setDelayer((Long)delayer);
            if ((Long)delayer > 0L) {
                this.log.debug("Delayer is enabled with: {} ms. on route: {}", delayer, (Object)((RouteDefinition)this.definition).getId());
            } else {
                this.log.debug("Delayer is disabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicies() != null && !((RouteDefinition)this.definition).getRoutePolicies().isEmpty()) {
            for (RoutePolicy policy2 : ((RouteDefinition)this.definition).getRoutePolicies()) {
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy2, (Object)((RouteDefinition)this.definition).getId());
                routeContext.getRoutePolicyList().add(policy2);
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicyRef() != null) {
            StringTokenizer policyTokens = new StringTokenizer(((RouteDefinition)this.definition).getRoutePolicyRef(), ",");
            while (policyTokens.hasMoreTokens()) {
                String ref = policyTokens.nextToken().trim();
                policy = (RoutePolicy)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)ref, RoutePolicy.class);
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy, (Object)((RouteDefinition)this.definition).getId());
                routeContext.getRoutePolicyList().add(policy);
            }
        }
        if (camelContext.getRoutePolicyFactories() != null) {
            for (RoutePolicyFactory factory : camelContext.getRoutePolicyFactories()) {
                policy = factory.createRoutePolicy(camelContext, ((RouteDefinition)this.definition).getId(), (NamedNode)this.definition);
                if (policy == null) continue;
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy, (Object)((RouteDefinition)this.definition).getId());
                routeContext.getRoutePolicyList().add(policy);
            }
        }
        if ((isAutoStartup = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getAutoStartup())) != null) {
            this.log.debug("Using AutoStartup {} on route: {}", (Object)isAutoStartup, (Object)((RouteDefinition)this.definition).getId());
            routeContext.setAutoStartup(isAutoStartup);
        }
        if (((RouteDefinition)this.definition).getStartupOrder() != null) {
            routeContext.setStartupOrder(((RouteDefinition)this.definition).getStartupOrder());
        }
        if (((RouteDefinition)this.definition).getShutdownRoute() != null) {
            this.log.debug("Using ShutdownRoute {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRoute(), (Object)((RouteDefinition)this.definition).getId());
            routeContext.setShutdownRoute(((RouteDefinition)this.definition).getShutdownRoute());
        }
        if (((RouteDefinition)this.definition).getShutdownRunningTask() != null) {
            this.log.debug("Using ShutdownRunningTask {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRunningTask(), (Object)((RouteDefinition)this.definition).getId());
            routeContext.setShutdownRunningTask(((RouteDefinition)this.definition).getShutdownRunningTask());
        }
        routeContext.setInterceptStrategies(((RouteDefinition)this.definition).getInterceptStrategies());
        Endpoint endpoint = ((RouteDefinition)this.definition).getInput().getEndpoint();
        if (endpoint == null) {
            EndpointConsumerBuilder def = ((RouteDefinition)this.definition).getInput().getEndpointConsumerBuilder();
            endpoint = def != null ? def.resolve(routeContext.getCamelContext()) : routeContext.resolveEndpoint(((RouteDefinition)this.definition).getInput().getEndpointUri());
        }
        routeContext.setEndpoint(endpoint);
        for (LifecycleStrategy strategy : camelContext.getLifecycleStrategies()) {
            strategy.onRouteContextCreate(routeContext);
        }
        if (!ProcessorDefinitionHelper.hasOutputs(((RouteDefinition)this.definition).getOutputs(), true)) {
            String at = ((RouteDefinition)this.definition).getInput().toString();
            IllegalArgumentException cause = new IllegalArgumentException("Route " + ((RouteDefinition)this.definition).getId() + " has no output processors. You need to add outputs to the route such as to(\"log:foo\").");
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), at, (Throwable)cause);
        }
        ArrayList list = new ArrayList(((RouteDefinition)this.definition).getOutputs());
        for (ProcessorDefinition processorDefinition : list) {
            try {
                ProcessorReifier.reifier(processorDefinition).addRoutes(routeContext);
            }
            catch (Exception e) {
                throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), processorDefinition.toString(), (Throwable)e);
            }
        }
        if (((RouteDefinition)this.definition).getRestBindingDefinition() != null) {
            try {
                routeContext.addAdvice((CamelInternalProcessorAdvice)new RestBindingReifier(((RouteDefinition)this.definition).getRestBindingDefinition()).createRestBindingAdvice(routeContext));
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if (((RouteDefinition)this.definition).getInputType() != null || ((RouteDefinition)this.definition).getOutputType() != null) {
            Contract contract = new Contract();
            if (((RouteDefinition)this.definition).getInputType() != null) {
                contract.setInputType(((RouteDefinition)this.definition).getInputType().getUrn());
                contract.setValidateInput(((RouteDefinition)this.definition).getInputType().isValidate());
            }
            if (((RouteDefinition)this.definition).getOutputType() != null) {
                contract.setOutputType(((RouteDefinition)this.definition).getOutputType().getUrn());
                contract.setValidateOutput(((RouteDefinition)this.definition).getOutputType().isValidate());
            }
            routeContext.addAdvice((CamelInternalProcessorAdvice)new ContractAdvice(contract));
            camelContext.setUseDataType(Boolean.valueOf(true));
        }
        routeContext.addProperty("id", (Object)((RouteDefinition)this.definition).getId());
        routeContext.addProperty("customId", (Object)(((RouteDefinition)this.definition).hasCustomIdAssigned() ? "true" : "false"));
        routeContext.addProperty("parent", (Object)Integer.toHexString(((RouteDefinition)this.definition).hashCode()));
        routeContext.addProperty("description", (Object)((RouteDefinition)this.definition).getDescriptionText());
        if (((RouteDefinition)this.definition).getGroup() != null) {
            routeContext.addProperty("group", (Object)((RouteDefinition)this.definition).getGroup());
        }
        String rest = Boolean.toString(((RouteDefinition)this.definition).isRest() != null && ((RouteDefinition)this.definition).isRest() != false);
        routeContext.addProperty("rest", (Object)rest);
        List<PropertyDefinition> list2 = ((RouteDefinition)this.definition).getRouteProperties();
        if (list2 != null) {
            String[] reservedProperties = new String[]{"id", "customId", "parent", "description", "group", "rest"};
            for (PropertyDefinition prop : list2) {
                try {
                    String key = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getKey());
                    String val = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getValue());
                    for (String property : reservedProperties) {
                        if (!property.equalsIgnoreCase(key)) continue;
                        throw new IllegalArgumentException("Cannot set route property " + property + " as it is a reserved property");
                    }
                    routeContext.addProperty(key, (Object)val);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
        return routeContext.commit();
    }
}

