/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.impl.engine.DefaultInterceptSendToEndpoint;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.URISupport;

public class InterceptSendToEndpointReifier
extends ProcessorReifier<InterceptSendToEndpointDefinition> {
    public InterceptSendToEndpointReifier(ProcessorDefinition<?> definition) {
        super((InterceptSendToEndpointDefinition)definition);
    }

    @Override
    public Processor createProcessor(final RouteContext routeContext) throws Exception {
        final Processor before = this.createChildProcessor(routeContext, true);
        Processor afterProcessor = null;
        if (((InterceptSendToEndpointDefinition)this.definition).getAfterUri() != null) {
            ToDefinition to = new ToDefinition(((InterceptSendToEndpointDefinition)this.definition).getAfterUri());
            if (((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory() != null) {
                afterProcessor = ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorFactory().createProcessor(routeContext, (NamedNode)to);
            }
            if (afterProcessor == null) {
                afterProcessor = InterceptSendToEndpointReifier.reifier(to).createProcessor(routeContext);
            }
        }
        final Processor after = afterProcessor;
        final String matchURI = ((InterceptSendToEndpointDefinition)this.definition).getUri();
        ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).registerEndpointCallback(new EndpointStrategy(){

            public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
                if (endpoint instanceof DefaultInterceptSendToEndpoint) {
                    return endpoint;
                }
                if (matchURI == null || InterceptSendToEndpointReifier.this.matchPattern(routeContext.getCamelContext(), uri, matchURI)) {
                    boolean skip = ((InterceptSendToEndpointDefinition)InterceptSendToEndpointReifier.this.definition).getSkipSendToOriginalEndpoint() != null && ((InterceptSendToEndpointDefinition)InterceptSendToEndpointReifier.this.definition).getSkipSendToOriginalEndpoint() != false;
                    DefaultInterceptSendToEndpoint proxy = new DefaultInterceptSendToEndpoint(endpoint, skip);
                    proxy.setBefore(before);
                    proxy.setAfter(after);
                    return proxy;
                }
                return endpoint;
            }
        });
        RouteDefinition route = (RouteDefinition)routeContext.getRoute();
        List<ProcessorDefinition<?>> outputs = route.getOutputs();
        outputs.remove(this);
        return new InterceptEndpointProcessor(matchURI, before);
    }

    protected boolean matchPattern(CamelContext camelContext, String uri, String pattern) {
        boolean match = EndpointHelper.matchEndpoint((CamelContext)camelContext, (String)uri, (String)pattern);
        if (!match) {
            try {
                pattern = URISupport.normalizeUri((String)pattern);
                match = EndpointHelper.matchEndpoint((CamelContext)camelContext, (String)uri, (String)pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return match;
    }
}

