/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Enricher;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.spi.RouteContext;

public class EnrichReifier
extends ExpressionReifier<EnrichDefinition> {
    public EnrichReifier(ProcessorDefinition<?> definition) {
        super((ExpressionNode)EnrichDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression exp = ((EnrichDefinition)this.definition).getExpression().createExpression(routeContext);
        boolean isShareUnitOfWork = ((EnrichDefinition)this.definition).getShareUnitOfWork() != null && ((EnrichDefinition)this.definition).getShareUnitOfWork() != false;
        boolean isIgnoreInvalidEndpoint = ((EnrichDefinition)this.definition).getIgnoreInvalidEndpoint() != null && ((EnrichDefinition)this.definition).getIgnoreInvalidEndpoint() != false;
        Enricher enricher = new Enricher(exp);
        enricher.setShareUnitOfWork(isShareUnitOfWork);
        enricher.setIgnoreInvalidEndpoint(isIgnoreInvalidEndpoint);
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        if (strategy != null) {
            enricher.setAggregationStrategy(strategy);
        }
        if (((EnrichDefinition)this.definition).getAggregateOnException() != null) {
            enricher.setAggregateOnException(((EnrichDefinition)this.definition).getAggregateOnException().booleanValue());
        }
        return enricher;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((EnrichDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((EnrichDefinition)this.definition).getAggregationStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(((EnrichDefinition)this.definition).getAggregationStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((EnrichDefinition)this.definition).getAggregationStrategyMethodName());
                if (((EnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(((EnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull().booleanValue());
                    adapter.setAllowNullOldExchange(((EnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull().booleanValue());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((EnrichDefinition)this.definition).getAggregationStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }
}

