/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.impl.DefaultModel;
import org.apache.camel.impl.RouteService;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.BaseRouteService;
import org.apache.camel.impl.engine.DefaultTransformerRegistry;
import org.apache.camel.impl.engine.DefaultValidatorRegistry;
import org.apache.camel.impl.transformer.TransformerKey;
import org.apache.camel.impl.validator.ValidatorKey;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.reifier.transformer.TransformerReifier;
import org.apache.camel.reifier.validator.ValidatorReifier;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractModelCamelContext
extends AbstractCamelContext
implements ModelCamelContext,
CatalogCamelContext {
    private final Model model = new DefaultModel(this);

    public AbstractModelCamelContext() {
        this(true);
    }

    public AbstractModelCamelContext(Registry registry) {
        this();
        this.setRegistry(registry);
    }

    public AbstractModelCamelContext(boolean init) {
        super(false);
        this.setDefaultExtension(HealthCheckRegistry.class, this::createHealthCheckRegistry);
        this.setDefaultExtension(RuntimeCamelCatalog.class, this::createRuntimeCamelCatalog);
        if (init) {
            this.init();
        }
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions() {
        return this.model.getRouteDefinitions();
    }

    @Override
    public RouteDefinition getRouteDefinition(String id) {
        return this.model.getRouteDefinition(id);
    }

    @Override
    public void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        this.model.addRouteDefinitions(routeDefinitions);
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.model.addRouteDefinition(routeDefinition);
    }

    @Override
    public void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        this.model.removeRouteDefinitions(routeDefinitions);
    }

    @Override
    public void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.model.removeRouteDefinition(routeDefinition);
    }

    @Override
    public List<RestDefinition> getRestDefinitions() {
        return this.model.getRestDefinitions();
    }

    @Override
    public void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        this.model.addRestDefinitions(restDefinitions, addToRoutes);
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.model.setDataFormats(dataFormats);
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.model.getDataFormats();
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        return this.model.resolveDataFormatDefinition(name);
    }

    @Override
    public ProcessorDefinition getProcessorDefinition(String id) {
        return this.model.getProcessorDefinition(id);
    }

    @Override
    public <T extends ProcessorDefinition> T getProcessorDefinition(String id, Class<T> type) {
        return this.model.getProcessorDefinition(id, type);
    }

    @Override
    public void setValidators(List<ValidatorDefinition> validators) {
        this.model.setValidators(validators);
    }

    @Override
    public HystrixConfigurationDefinition getHystrixConfiguration(String id) {
        return this.model.getHystrixConfiguration(id);
    }

    @Override
    public void setHystrixConfiguration(HystrixConfigurationDefinition configuration) {
        this.model.setHystrixConfiguration(configuration);
    }

    @Override
    public void setHystrixConfigurations(List<HystrixConfigurationDefinition> configurations) {
        this.model.setHystrixConfigurations(configurations);
    }

    @Override
    public void addHystrixConfiguration(String id, HystrixConfigurationDefinition configuration) {
        this.model.addHystrixConfiguration(id, configuration);
    }

    @Override
    public List<ValidatorDefinition> getValidators() {
        return this.model.getValidators();
    }

    @Override
    public void setTransformers(List<TransformerDefinition> transformers) {
        this.model.setTransformers(transformers);
    }

    @Override
    public List<TransformerDefinition> getTransformers() {
        return this.model.getTransformers();
    }

    @Override
    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        return this.model.getServiceCallConfiguration(serviceName);
    }

    @Override
    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        this.model.setServiceCallConfiguration(configuration);
    }

    @Override
    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        this.model.setServiceCallConfigurations(configurations);
    }

    @Override
    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        this.model.addServiceCallConfiguration(serviceName, configuration);
    }

    @Override
    public void setRouteFilterPattern(String include, String exclude) {
        this.model.setRouteFilterPattern(include, exclude);
    }

    @Override
    public void setRouteFilter(Function<RouteDefinition, Boolean> filter) {
        this.model.setRouteFilter(filter);
    }

    @Override
    public Function<RouteDefinition, Boolean> getRouteFilter() {
        return this.model.getRouteFilter();
    }

    protected ValidatorRegistry<ValidatorKey> createValidatorRegistry() throws Exception {
        DefaultValidatorRegistry registry = new DefaultValidatorRegistry((CamelContext)this);
        for (ValidatorDefinition def : this.getValidators()) {
            Validator validator = ValidatorReifier.reifier(def).createValidator(this);
            registry.put((Object)this.createKey(def), this.doAddService(validator));
        }
        return registry;
    }

    private ValidatorKey createKey(ValidatorDefinition def) {
        return new ValidatorKey(new DataType(def.getType()));
    }

    protected TransformerRegistry<TransformerKey> createTransformerRegistry() throws Exception {
        DefaultTransformerRegistry registry = new DefaultTransformerRegistry((CamelContext)this);
        for (TransformerDefinition def : this.getTransformers()) {
            Transformer transformer = TransformerReifier.reifier(def).createTransformer(this);
            registry.put((Object)this.createKey(def), this.doAddService(transformer));
        }
        return registry;
    }

    private TransformerKey createKey(TransformerDefinition def) {
        return ObjectHelper.isNotEmpty((Object)def.getScheme()) ? new TransformerKey(def.getScheme()) : new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }

    protected abstract HealthCheckRegistry createHealthCheckRegistry();

    protected abstract RuntimeCamelCatalog createRuntimeCamelCatalog();

    protected void doStartStandardServices() {
        super.doStartStandardServices();
        this.getExtension(RuntimeCamelCatalog.class);
    }

    protected void doStartEagerServices() {
        this.getExtension(HealthCheckRegistry.class);
        super.doStartEagerServices();
    }

    protected void bindDataFormats() throws Exception {
        for (Map.Entry<String, DataFormatDefinition> e : this.model.getDataFormats().entrySet()) {
            String id = e.getKey();
            DataFormatDefinition def = e.getValue();
            this.log.debug("Creating Dataformat with id: {} and definition: {}", (Object)id, (Object)def);
            DataFormat df = DataFormatReifier.reifier(def).createDataFormat(this);
            this.addService(df, true);
            this.getRegistry().bind(id, (Object)df);
        }
    }

    protected synchronized void shutdownRouteService(BaseRouteService routeService) throws Exception {
        if (routeService instanceof RouteService) {
            this.model.getRouteDefinitions().remove(((RouteService)routeService).getRouteDefinition());
        }
        super.shutdownRouteService(routeService);
    }

    protected boolean isStreamCachingInUse() throws Exception {
        boolean streamCachingInUse = super.isStreamCachingInUse();
        if (!streamCachingInUse) {
            for (RouteDefinition route : this.model.getRouteDefinitions()) {
                Boolean routeCache = CamelContextHelper.parseBoolean((CamelContext)this, (String)route.getStreamCache());
                if (routeCache == null || !routeCache.booleanValue()) continue;
                streamCachingInUse = true;
                break;
            }
        }
        return streamCachingInUse;
    }

    @Override
    public void startRouteDefinitions() throws Exception {
        this.model.startRouteDefinitions();
    }

    public AsyncProcessor createMulticast(Collection<Processor> processors, ExecutorService executor, boolean shutdownExecutorService) {
        return new MulticastProcessor((CamelContext)this, processors, null, true, executor, shutdownExecutorService, false, false, 0L, null, false, false);
    }
}

