/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.apache.camel.Exchange;
import org.apache.camel.converter.crypto.HMACAccumulator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="crypto")
public class CryptoDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    public static final String KEY = "CamelCryptoKey";
    private static final Logger LOG = LoggerFactory.getLogger(CryptoDataFormat.class);
    private static final String INIT_VECTOR = "CamelCryptoInitVector";
    private String algorithm = "DES/CBC/PKCS5Padding";
    private String cryptoProvider;
    private Key configuredkey;
    private int bufferSize = 4096;
    private byte[] initializationVector;
    private boolean inline;
    private String macAlgorithm = "HmacSHA1";
    private boolean shouldAppendHMAC;
    private AlgorithmParameterSpec parameterSpec;

    public CryptoDataFormat() {
    }

    public CryptoDataFormat(String algorithm, Key key) {
        this(algorithm, key, null);
    }

    public CryptoDataFormat(String algorithm, Key key, String cryptoProvider) {
        this.algorithm = algorithm;
        this.configuredkey = key;
        this.cryptoProvider = cryptoProvider;
    }

    public String getDataFormatName() {
        return "crypto";
    }

    private Cipher initializeCipher(int mode, Key key, byte[] iv) throws Exception {
        Cipher cipher;
        Cipher cipher2 = cipher = this.cryptoProvider == null ? Cipher.getInstance(this.algorithm) : Cipher.getInstance(this.algorithm, this.cryptoProvider);
        if (key == null) {
            throw new IllegalStateException("A valid encryption key is required. Either configure the CryptoDataFormat with a key or provide one in a header using the header name 'CamelCryptoKey'");
        }
        if (mode == 1 || mode == 2) {
            if (iv != null) {
                cipher.init(mode, key, new IvParameterSpec(iv));
            } else if (this.parameterSpec != null) {
                cipher.init(mode, key, this.parameterSpec);
            } else {
                cipher.init(mode, key);
            }
        }
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        byte[] iv = this.getInitializationVector(exchange);
        Key key = this.getKey(exchange);
        InputStream plaintextStream = (InputStream)ExchangeHelper.convertToMandatoryType((Exchange)exchange, InputStream.class, (Object)graph);
        HMACAccumulator hmac = this.getMessageAuthenticationCode(key);
        if (plaintextStream != null) {
            CipherOutputStream cipherStream;
            block4: {
                this.inlineInitVector(outputStream, iv);
                byte[] buffer = new byte[this.bufferSize];
                cipherStream = null;
                try {
                    int read;
                    cipherStream = new CipherOutputStream(outputStream, this.initializeCipher(1, key, iv));
                    while ((read = plaintextStream.read(buffer)) > 0) {
                        cipherStream.write(buffer, 0, read);
                        cipherStream.flush();
                        hmac.encryptUpdate(buffer, read);
                    }
                    byte[] mac = hmac.getCalculatedMac();
                    if (mac == null || mac.length <= 0) break block4;
                    cipherStream.write(mac);
                }
                catch (Throwable throwable) {
                    IOHelper.close(cipherStream, (String)"cipher", (Logger)LOG);
                    IOHelper.close((Closeable)plaintextStream, (String)"plaintext", (Logger)LOG);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)cipherStream, (String)"cipher", (Logger)LOG);
            IOHelper.close((Closeable)plaintextStream, (String)"plaintext", (Logger)LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream encryptedStream) throws Exception {
        if (encryptedStream != null) {
            Object object;
            byte[] iv = this.getInlinedInitializationVector(exchange, encryptedStream);
            Key key = this.getKey(exchange);
            CipherInputStream cipherStream = null;
            OutputStreamBuilder osb = null;
            try {
                int read;
                cipherStream = new CipherInputStream(encryptedStream, this.initializeCipher(2, key, iv));
                osb = OutputStreamBuilder.withExchange((Exchange)exchange);
                HMACAccumulator hmac = this.getMessageAuthenticationCode(key);
                byte[] buffer = new byte[this.bufferSize];
                hmac.attachStream((OutputStream)osb);
                while ((read = cipherStream.read(buffer)) >= 0) {
                    hmac.decryptUpdate(buffer, read);
                }
                hmac.validate();
                object = osb.build();
            }
            catch (Throwable throwable) {
                IOHelper.close(cipherStream, (String)"cipher", (Logger)LOG);
                IOHelper.close(osb, (String)"plaintext", (Logger)LOG);
                throw throwable;
            }
            IOHelper.close((Closeable)cipherStream, (String)"cipher", (Logger)LOG);
            IOHelper.close((Closeable)osb, (String)"plaintext", (Logger)LOG);
            return object;
        }
        return null;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    private void inlineInitVector(OutputStream outputStream, byte[] iv) throws IOException {
        if (this.inline) {
            if (iv == null) {
                throw new IllegalStateException("Inlining cannot be performed, as no initialization vector was specified");
            }
            DataOutputStream dout = new DataOutputStream(outputStream);
            dout.writeInt(iv.length);
            outputStream.write(iv);
            outputStream.flush();
        }
    }

    private byte[] getInlinedInitializationVector(Exchange exchange, InputStream encryptedStream) throws IOException {
        byte[] iv = this.getInitializationVector(exchange);
        if (this.inline) {
            try {
                int ivLength = new DataInputStream(encryptedStream).readInt();
                iv = new byte[ivLength];
                int read = encryptedStream.read(iv);
                if (read != ivLength) {
                    throw new IOException(String.format("Attempted to read a '%d' byte initialization vector from inputStream but only '%d' bytes were retrieved", ivLength, read));
                }
            }
            catch (IOException e) {
                throw new IOException("Error reading initialization vector from encrypted stream", e);
            }
        }
        return iv;
    }

    private HMACAccumulator getMessageAuthenticationCode(Key key) throws Exception {
        return this.shouldAppendHMAC ? new HMACAccumulator(key, this.macAlgorithm, this.cryptoProvider, this.bufferSize) : new HMACAccumulator(){
            byte[] empty = new byte[0];

            @Override
            public void encryptUpdate(byte[] buffer, int read) {
            }

            @Override
            public void decryptUpdate(byte[] buffer, int read) throws IOException {
                this.outputStream.write(buffer, 0, read);
            }

            @Override
            public void validate() {
            }

            @Override
            public byte[] getCalculatedMac() {
                return this.empty;
            }
        };
    }

    private byte[] getInitializationVector(Exchange exchange) {
        byte[] iv = (byte[])exchange.getIn().getHeader(INIT_VECTOR, byte[].class);
        if (iv == null) {
            iv = this.initializationVector;
        }
        return iv;
    }

    private Key getKey(Exchange exchange) {
        Key key = (Key)exchange.getIn().getHeader(KEY, Key.class);
        if (key != null) {
            exchange.getIn().setHeader(KEY, null);
        } else {
            key = this.configuredkey;
        }
        return key;
    }

    public void setInitializationVector(byte[] initializationVector) {
        if (initializationVector != null) {
            this.initializationVector = initializationVector;
        }
    }

    public void setShouldInlineInitializationVector(boolean inline) {
        this.inline = inline;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec parameterSpec) {
        this.parameterSpec = parameterSpec;
    }

    public void setCryptoProvider(String cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public void setShouldAppendHMAC(boolean shouldAppendHMAC) {
        this.shouldAppendHMAC = shouldAppendHMAC;
    }

    public void setKey(Key key) {
        this.configuredkey = key;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

