/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.JmxManagementLifecycleStrategy;
import org.apache.camel.management.JmxManagementStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ManagementStrategyFactory;
import org.apache.camel.support.PropertyBindingSupport;

public class JmxManagementStrategyFactory
implements ManagementStrategyFactory {
    public ManagementStrategy create(CamelContext context, Map<String, Object> options) throws Exception {
        DefaultManagementAgent agent = new DefaultManagementAgent(context);
        if (options != null) {
            PropertyBindingSupport.build().bind(context, (Object)agent, options);
        }
        return new JmxManagementStrategy(context, agent);
    }

    public LifecycleStrategy createLifecycle(CamelContext context) throws Exception {
        return new JmxManagementLifecycleStrategy(context);
    }

    public void setupManagement(CamelContext camelContext, ManagementStrategy strategy, LifecycleStrategy lifecycle) {
        camelContext.setManagementStrategy(strategy);
        if (!camelContext.getLifecycleStrategies().isEmpty()) {
            List<JmxManagementLifecycleStrategy.PreRegisterService> preServices = null;
            JmxManagementLifecycleStrategy jmx = camelContext.getLifecycleStrategies().stream().filter(s -> s instanceof JmxManagementLifecycleStrategy).map(JmxManagementLifecycleStrategy.class::cast).findFirst().orElse(null);
            if (jmx != null) {
                preServices = jmx.getPreServices();
            }
            if (preServices != null && !preServices.isEmpty() && lifecycle instanceof JmxManagementLifecycleStrategy) {
                JmxManagementLifecycleStrategy existing = (JmxManagementLifecycleStrategy)lifecycle;
                for (JmxManagementLifecycleStrategy.PreRegisterService pre : preServices) {
                    existing.addPreService(pre);
                }
            }
            camelContext.getLifecycleStrategies().removeIf(s -> s instanceof JmxManagementLifecycleStrategy);
        }
        camelContext.getLifecycleStrategies().add(0, lifecycle);
    }
}

