/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.sqs.MessageDeduplicationIdStrategy;
import org.apache.camel.component.aws.sqs.MessageGroupIdStrategy;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.component.aws.sqs.SqsOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SqsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return SqsEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return SqsEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "amazonSQSClient": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAmazonSQSClient((AmazonSQS)SqsEndpointConfigurer.property((CamelContext)camelContext, AmazonSQS.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonAWSHost": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAmazonAWSHost((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "queueOwnerAWSAccountId": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setQueueOwnerAWSAccountId((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "autoCreateQueue": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAutoCreateQueue((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteAfterRead": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDeleteAfterRead((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteIfFiltered": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDeleteIfFiltered((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "visibilityTimeout": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setVisibilityTimeout((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "attributeNames": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAttributeNames((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "messageAttributeNames": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageAttributeNames((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "waitTimeSeconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setWaitTimeSeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "defaultVisibilityTimeout": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDefaultVisibilityTimeout((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "extendMessageVisibility": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setExtendMessageVisibility((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "kmsMasterKeyId": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setKmsMasterKeyId((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kmsDataKeyReusePeriodSeconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setKmsDataKeyReusePeriodSeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "serverSideEncryptionEnabled": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setServerSideEncryptionEnabled((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "concurrentConsumers": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setConcurrentConsumers((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "queueUrl": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setQueueUrl((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "delaySeconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDelaySeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "delayQueue": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDelayQueue((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messageGroupIdStrategy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageGroupIdStrategy((MessageGroupIdStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, MessageGroupIdStrategy.class, (Object)value));
                return true;
            }
            case "messageDeduplicationIdStrategy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageDeduplicationIdStrategy((MessageDeduplicationIdStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, MessageDeduplicationIdStrategy.class, (Object)value));
                return true;
            }
            case "operation": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setOperation((SqsOperations)((Object)SqsEndpointConfigurer.property((CamelContext)camelContext, SqsOperations.class, (Object)value)));
                return true;
            }
            case "maximumMessageSize": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMaximumMessageSize((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "messageRetentionPeriod": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageRetentionPeriod((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "receiveMessageWaitTimeSeconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setReceiveMessageWaitTimeSeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "policy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setPolicy((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "redrivePolicy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setRedrivePolicy((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "protocol": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setProtocol((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxMessagesPerPoll": {
                ((SqsEndpoint)((Object)endpoint)).setMaxMessagesPerPoll((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "headerFilterStrategy": {
                ((SqsEndpoint)((Object)endpoint)).setHeaderFilterStrategy((HeaderFilterStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((SqsEndpoint)((Object)endpoint)).setStartScheduler((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((SqsEndpoint)((Object)endpoint)).setInitialDelay((Long)SqsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((SqsEndpoint)((Object)endpoint)).setDelay((Long)SqsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((SqsEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)SqsEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((SqsEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((SqsEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((SqsEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)SqsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((SqsEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((SqsEndpoint)((Object)endpoint)).setGreedy((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((SqsEndpoint)((Object)endpoint)).setScheduler((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((SqsEndpoint)((Object)endpoint)).setSchedulerProperties((Map)SqsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((SqsEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)SqsEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((SqsEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((SqsEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((SqsEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((SqsEndpoint)((Object)endpoint)).setRepeatCount((Long)SqsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((SqsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((SqsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((SqsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SqsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((SqsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SqsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SqsEndpoint)((Object)endpoint)).setSynchronous((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((SqsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "amazonsqsclient": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAmazonSQSClient((AmazonSQS)SqsEndpointConfigurer.property((CamelContext)camelContext, AmazonSQS.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonawshost": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAmazonAWSHost((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "queueownerawsaccountid": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setQueueOwnerAWSAccountId((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "autocreatequeue": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAutoCreateQueue((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteafterread": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDeleteAfterRead((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteiffiltered": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDeleteIfFiltered((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "visibilitytimeout": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setVisibilityTimeout((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "attributenames": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setAttributeNames((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "messageattributenames": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageAttributeNames((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "waittimeseconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setWaitTimeSeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "defaultvisibilitytimeout": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDefaultVisibilityTimeout((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "extendmessagevisibility": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setExtendMessageVisibility((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "kmsmasterkeyid": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setKmsMasterKeyId((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kmsdatakeyreuseperiodseconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setKmsDataKeyReusePeriodSeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "serversideencryptionenabled": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setServerSideEncryptionEnabled((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "concurrentconsumers": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setConcurrentConsumers((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "queueurl": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setQueueUrl((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "delayseconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDelaySeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "delayqueue": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setDelayQueue((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messagegroupidstrategy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageGroupIdStrategy((MessageGroupIdStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, MessageGroupIdStrategy.class, (Object)value));
                return true;
            }
            case "messagededuplicationidstrategy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageDeduplicationIdStrategy((MessageDeduplicationIdStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, MessageDeduplicationIdStrategy.class, (Object)value));
                return true;
            }
            case "operation": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setOperation((SqsOperations)((Object)SqsEndpointConfigurer.property((CamelContext)camelContext, SqsOperations.class, (Object)value)));
                return true;
            }
            case "maximummessagesize": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMaximumMessageSize((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "messageretentionperiod": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setMessageRetentionPeriod((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "receivemessagewaittimeseconds": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setReceiveMessageWaitTimeSeconds((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "policy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setPolicy((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "redrivepolicy": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setRedrivePolicy((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "protocol": {
                ((SqsEndpoint)((Object)endpoint)).getConfiguration().setProtocol((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxmessagesperpoll": {
                ((SqsEndpoint)((Object)endpoint)).setMaxMessagesPerPoll((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "headerfilterstrategy": {
                ((SqsEndpoint)((Object)endpoint)).setHeaderFilterStrategy((HeaderFilterStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((SqsEndpoint)((Object)endpoint)).setStartScheduler((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((SqsEndpoint)((Object)endpoint)).setInitialDelay((Long)SqsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((SqsEndpoint)((Object)endpoint)).setDelay((Long)SqsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((SqsEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)SqsEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((SqsEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((SqsEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)SqsEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((SqsEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)SqsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((SqsEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((SqsEndpoint)((Object)endpoint)).setGreedy((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((SqsEndpoint)((Object)endpoint)).setScheduler((String)SqsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((SqsEndpoint)((Object)endpoint)).setSchedulerProperties((Map)SqsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((SqsEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)SqsEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((SqsEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((SqsEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((SqsEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)SqsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((SqsEndpoint)((Object)endpoint)).setRepeatCount((Long)SqsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((SqsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((SqsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((SqsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SqsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((SqsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SqsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SqsEndpoint)((Object)endpoint)).setSynchronous((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((SqsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SqsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

