/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.JSonSchemaResolver;

public class CamelCatalogJSonSchemaResolver
implements JSonSchemaResolver {
    private static final String MODEL_DIR = "org/apache/camel/catalog/models";
    private final CamelCatalog camelCatalog;
    private final Map<String, String> extraComponents;
    private final Map<String, String> extraComponentsJSonSchema;
    private final Map<String, String> extraDataFormats;
    private final Map<String, String> extraDataFormatsJSonSchema;

    public CamelCatalogJSonSchemaResolver(CamelCatalog camelCatalog, Map<String, String> extraComponents, Map<String, String> extraComponentsJSonSchema, Map<String, String> extraDataFormats, Map<String, String> extraDataFormatsJSonSchema) {
        this.camelCatalog = camelCatalog;
        this.extraComponents = extraComponents;
        this.extraComponentsJSonSchema = extraComponentsJSonSchema;
        this.extraDataFormats = extraDataFormats;
        this.extraDataFormatsJSonSchema = extraDataFormatsJSonSchema;
    }

    @Override
    public String getComponentJSonSchema(String name) {
        String file = this.camelCatalog.getRuntimeProvider().getComponentJSonSchemaDirectory() + "/" + name + ".json";
        String fromVersionManager = this.loadResourceFromVersionManager(file);
        if (fromVersionManager != null) {
            return fromVersionManager;
        }
        String answer = this.extraComponentsJSonSchema.get(name);
        if (answer != null) {
            return answer;
        }
        String className = this.extraComponents.get(name);
        return this.loadFromClasspath(className, name);
    }

    @Override
    public String getDataFormatJSonSchema(String name) {
        String file = this.camelCatalog.getRuntimeProvider().getDataFormatJSonSchemaDirectory() + "/" + name + ".json";
        String fromVersionManager = this.loadResourceFromVersionManager(file);
        if (fromVersionManager != null) {
            return fromVersionManager;
        }
        String schema = this.extraDataFormatsJSonSchema.get(name);
        if (schema != null) {
            return schema;
        }
        String className = this.extraDataFormats.get(name);
        return this.loadFromClasspath(className, name);
    }

    @Override
    public String getLanguageJSonSchema(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = this.camelCatalog.getRuntimeProvider().getLanguageJSonSchemaDirectory() + "/" + name + ".json";
        return this.loadResourceFromVersionManager(file);
    }

    @Override
    public String getModelJSonSchema(String name) {
        String file = "org/apache/camel/catalog/models/" + name + ".json";
        return this.loadResourceFromVersionManager(file);
    }

    @Override
    public String getOtherJSonSchema(String name) {
        String file = this.camelCatalog.getRuntimeProvider().getOtherJSonSchemaDirectory() + "/" + name + ".json";
        return this.loadResourceFromVersionManager(file);
    }

    String loadFromClasspath(String className, String fileName) {
        if (className != null) {
            String packageName = className.substring(0, className.lastIndexOf(46));
            packageName = packageName.replace('.', '/');
            String path = packageName + "/" + fileName + ".json";
            return this.loadResourceFromVersionManager(path);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String loadResourceFromVersionManager(String file) {
        try (InputStream is = this.camelCatalog.getVersionManager().getResourceAsStream(file);){
            if (is == null) return null;
            String string = CatalogHelper.loadText(is);
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

