/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud.zookeeper;

import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.serviceregistry.ServiceInstanceRegistration;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperRegistration;
import org.springframework.core.convert.converter.Converter;

public final class ServiceDefinitionToZookeeperRegistration
implements Converter<ServiceDefinition, ZookeeperRegistration> {
    private final CamelCloudConfigurationProperties properties;

    public ServiceDefinitionToZookeeperRegistration(CamelCloudConfigurationProperties properties) {
        this.properties = properties;
    }

    public ZookeeperRegistration convert(ServiceDefinition source) {
        ZookeeperInstance instance = new ZookeeperInstance(source.getId(), source.getName(), source.getMetadata());
        return ServiceInstanceRegistration.builder().address(this.properties.getServiceRegistry().getServiceHost()).port(source.getPort()).name(source.getName()).payload(instance).uriSpec("{scheme}://{address}:{port}").build();
    }
}

