/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;

public class NatsConsumer
extends DefaultConsumer {
    private final Processor processor;
    private ExecutorService executor;
    private Connection connection;
    private Dispatcher dispatcher;
    private boolean active;

    public NatsConsumer(NatsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.log.debug("Starting Nats Consumer");
        this.executor = this.getEndpoint().createExecutor();
        this.log.debug("Getting Nats Connection");
        this.connection = this.getEndpoint().getConfiguration().getConnection() != null ? this.getEndpoint().getConfiguration().getConnection() : this.getEndpoint().getConnection();
        this.executor.submit(new NatsConsumingTask(this.connection, this.getEndpoint().getConfiguration()));
    }

    protected void doStop() throws Exception {
        if (this.getEndpoint().getConfiguration().isFlushConnection()) {
            this.log.debug("Flushing Messages before stopping");
            this.connection.flush(Duration.ofMillis(this.getEndpoint().getConfiguration().getFlushTimeout()));
        }
        try {
            this.dispatcher.unsubscribe(this.getEndpoint().getConfiguration().getTopic());
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error during unsubscribing", (Throwable)e);
        }
        this.log.debug("Stopping Nats Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
        if (ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getConnection())) {
            this.log.debug("Closing Nats Connection");
            if (!this.connection.getStatus().equals((Object)Connection.Status.CLOSED)) {
                this.connection.close();
            }
        }
        super.doStop();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    class NatsConsumingTask
    implements Runnable {
        private final Connection connection;
        private final NatsConfiguration configuration;

        NatsConsumingTask(Connection connection, NatsConfiguration configuration) {
            this.connection = connection;
            this.configuration = configuration;
        }

        @Override
        public void run() {
            try {
                NatsConsumer.this.dispatcher = this.connection.createDispatcher((MessageHandler)new CamelNatsMessageHandler());
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getQueueName())) {
                    NatsConsumer.this.dispatcher = NatsConsumer.this.dispatcher.subscribe(NatsConsumer.this.getEndpoint().getConfiguration().getTopic(), NatsConsumer.this.getEndpoint().getConfiguration().getQueueName());
                    if (ObjectHelper.isNotEmpty((Object)NatsConsumer.this.getEndpoint().getConfiguration().getMaxMessages())) {
                        NatsConsumer.this.dispatcher.unsubscribe(NatsConsumer.this.getEndpoint().getConfiguration().getTopic(), Integer.parseInt(NatsConsumer.this.getEndpoint().getConfiguration().getMaxMessages()));
                    }
                    if (NatsConsumer.this.dispatcher.isActive()) {
                        NatsConsumer.this.setActive(true);
                    }
                } else {
                    NatsConsumer.this.dispatcher = NatsConsumer.this.dispatcher.subscribe(NatsConsumer.this.getEndpoint().getConfiguration().getTopic());
                    if (ObjectHelper.isNotEmpty((Object)NatsConsumer.this.getEndpoint().getConfiguration().getMaxMessages())) {
                        NatsConsumer.this.dispatcher.unsubscribe(NatsConsumer.this.getEndpoint().getConfiguration().getTopic(), Integer.parseInt(NatsConsumer.this.getEndpoint().getConfiguration().getMaxMessages()));
                    }
                    if (NatsConsumer.this.dispatcher.isActive()) {
                        NatsConsumer.this.setActive(true);
                    }
                }
            }
            catch (Throwable e) {
                NatsConsumer.this.getExceptionHandler().handleException("Error during processing", e);
            }
        }

        class CamelNatsMessageHandler
        implements MessageHandler {
            CamelNatsMessageHandler() {
            }

            public void onMessage(Message msg) throws InterruptedException {
                NatsConsumer.this.log.debug("Received Message: {}", (Object)msg);
                Exchange exchange = NatsConsumer.this.getEndpoint().createExchange();
                exchange.getIn().setBody((Object)msg);
                exchange.getIn().setHeader("CamelNatsMessageTimestamp", (Object)System.currentTimeMillis());
                try {
                    NatsConsumer.this.processor.process(exchange);
                }
                catch (Exception e) {
                    NatsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                }
            }
        }
    }
}

