/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xchange.XChange;
import org.apache.camel.component.xchange.XChangeAccountProducer;
import org.apache.camel.component.xchange.XChangeComponent;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeMarketDataProducer;
import org.apache.camel.component.xchange.XChangeMetaDataProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.utils.Assert;

@UriEndpoint(firstVersion="2.21.0", scheme="xchange", title="XChange", syntax="xchange:name", producerOnly=true, label="bitcoin,blockchain")
public class XChangeEndpoint
extends DefaultEndpoint {
    @UriParam
    private final XChangeConfiguration configuration;
    private final XChange exchange;

    public XChangeEndpoint(String uri, XChangeComponent component, XChangeConfiguration configuration, XChange exchange) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.exchange = exchange;
    }

    public XChangeComponent getComponent() {
        return (XChangeComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Producer createProducer() throws Exception {
        DefaultProducer producer = null;
        XChangeConfiguration.XChangeService service = this.getConfiguration().getService();
        if (XChangeConfiguration.XChangeService.account == service) {
            producer = new XChangeAccountProducer(this);
        } else if (XChangeConfiguration.XChangeService.marketdata == service) {
            producer = new XChangeMarketDataProducer(this);
        } else if (XChangeConfiguration.XChangeService.metadata == service) {
            producer = new XChangeMetaDataProducer(this);
        }
        Assert.notNull((Object)producer, (String)("Unsupported service: " + (Object)((Object)service)));
        return producer;
    }

    public XChangeConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<Currency> getCurrencies() {
        ExchangeMetaData metaData = this.exchange.getExchangeMetaData();
        return metaData.getCurrencies().keySet().stream().sorted().collect(Collectors.toList());
    }

    public CurrencyMetaData getCurrencyMetaData(Currency curr) {
        Assert.notNull((Object)curr, (String)"Null currency");
        ExchangeMetaData metaData = this.exchange.getExchangeMetaData();
        return (CurrencyMetaData)metaData.getCurrencies().get(curr);
    }

    public List<CurrencyPair> getCurrencyPairs() {
        ExchangeMetaData metaData = this.exchange.getExchangeMetaData();
        return metaData.getCurrencyPairs().keySet().stream().sorted().collect(Collectors.toList());
    }

    public CurrencyPairMetaData getCurrencyPairMetaData(CurrencyPair pair) {
        Assert.notNull((Object)pair, (String)"Null currency");
        ExchangeMetaData metaData = this.exchange.getExchangeMetaData();
        return (CurrencyPairMetaData)metaData.getCurrencyPairs().get(pair);
    }

    public List<Balance> getBalances() throws IOException {
        ArrayList balances = new ArrayList();
        this.getWallets().stream().forEach(w -> {
            for (Balance aux : w.getBalances().values()) {
                Currency curr = aux.getCurrency();
                CurrencyMetaData metaData = this.getCurrencyMetaData(curr);
                if (metaData == null) continue;
                int scale = metaData.getScale();
                double total = aux.getTotal().doubleValue();
                double scaledTotal = total * Math.pow(10.0, scale / 2);
                if (!(1.0 <= scaledTotal)) continue;
                balances.add(aux);
            }
        });
        return balances.stream().sorted(new Comparator<Balance>(){

            @Override
            public int compare(Balance o1, Balance o2) {
                return o1.getCurrency().compareTo(o2.getCurrency());
            }
        }).collect(Collectors.toList());
    }

    public List<FundingRecord> getFundingHistory() throws IOException {
        AccountService accountService = this.exchange.getAccountService();
        TradeHistoryParams fundingHistoryParams = accountService.createFundingHistoryParams();
        return accountService.getFundingHistory(fundingHistoryParams).stream().sorted(new Comparator<FundingRecord>(){

            @Override
            public int compare(FundingRecord o1, FundingRecord o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        }).collect(Collectors.toList());
    }

    public List<Wallet> getWallets() throws IOException {
        AccountService accountService = this.exchange.getAccountService();
        AccountInfo accountInfo = accountService.getAccountInfo();
        return accountInfo.getWallets().values().stream().sorted(new Comparator<Wallet>(){

            @Override
            public int compare(Wallet o1, Wallet o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }).collect(Collectors.toList());
    }

    public Ticker getTicker(CurrencyPair pair) throws IOException {
        Assert.notNull((Object)pair, (String)"Null currency pair");
        MarketDataService marketService = this.exchange.getMarketDataService();
        return marketService.getTicker(pair, new Object[0]);
    }
}

