/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.net.URL;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.service.lra.LRAClient;
import org.apache.camel.service.lra.LRASagaCoordinator;
import org.apache.camel.service.lra.LRASagaRoutes;
import org.apache.camel.support.service.ServiceSupport;

public class LRASagaService
extends ServiceSupport
implements CamelSagaService {
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;
    private LRAClient client;
    private LRASagaRoutes routes;
    private String coordinatorUrl;
    private String coordinatorContextPath = "/lra-coordinator";
    private String localParticipantUrl;
    private String localParticipantContextPath = "/lra-participant";
    private Set<String> sagaURIs = ConcurrentHashMap.newKeySet();

    public CompletableFuture<CamelSagaCoordinator> newSaga() {
        return this.client.newLRA().thenApply(url -> new LRASagaCoordinator(this, (URL)url));
    }

    public CompletableFuture<CamelSagaCoordinator> getSaga(String id) {
        CompletableFuture<CamelSagaCoordinator> coordinator = new CompletableFuture<CamelSagaCoordinator>();
        try {
            coordinator.complete(new LRASagaCoordinator(this, new URL(id)));
        }
        catch (Exception ex) {
            coordinator.completeExceptionally(ex);
        }
        return coordinator;
    }

    public void registerStep(CamelSagaStep step) {
        step.getCompensation().map(Endpoint::getEndpointUri).map(this.sagaURIs::add);
        step.getCompletion().map(Endpoint::getEndpointUri).map(this.sagaURIs::add);
    }

    protected void doStart() throws Exception {
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceManager().newDefaultScheduledThreadPool((Object)this, "saga-lra");
        }
        if (this.client == null) {
            this.client = new LRAClient(this);
        }
    }

    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            this.executorService = null;
        }
        if (this.client != null) {
            this.client = null;
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        if (this.routes == null) {
            this.routes = new LRASagaRoutes(this);
            try {
                this.camelContext.addRoutes((RoutesBuilder)this.routes);
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public LRAClient getClient() {
        return this.client;
    }

    public String getCoordinatorUrl() {
        return this.coordinatorUrl;
    }

    public void setCoordinatorUrl(String coordinatorUrl) {
        this.coordinatorUrl = coordinatorUrl;
    }

    public String getCoordinatorContextPath() {
        return this.coordinatorContextPath;
    }

    public void setCoordinatorContextPath(String coordinatorContextPath) {
        this.coordinatorContextPath = coordinatorContextPath;
    }

    public String getLocalParticipantUrl() {
        return this.localParticipantUrl;
    }

    public void setLocalParticipantUrl(String localParticipantUrl) {
        this.localParticipantUrl = localParticipantUrl;
    }

    public String getLocalParticipantContextPath() {
        return this.localParticipantContextPath;
    }

    public void setLocalParticipantContextPath(String localParticipantContextPath) {
        this.localParticipantContextPath = localParticipantContextPath;
    }

    public Set<String> getRegisteredURIs() {
        return this.sagaURIs;
    }
}

