/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.service.lra.springboot.LraServiceConfiguration;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.support.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={LraServiceConfiguration.class})
public class LraServiceAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LraServiceAutoConfiguration.class);
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private LraServiceConfiguration configuration;

    @Bean(name={"lra-service"})
    @ConditionalOnMissingBean(value={CamelSagaService.class})
    @ConditionalOnProperty(value={"camel.service.lra.enabled"}, havingValue="true")
    public LRASagaService configureLraSagaService() throws Exception {
        LRASagaService service = new LRASagaService();
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)this.configuration, parameters, null, (boolean)false);
        CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)service, parameters, (boolean)false);
        this.camelContext.addService((Object)service);
        return service;
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel.service", "camel.service.lra");
        }
    }
}

