/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.topic;

import com.hazelcast.core.HazelcastInstance;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.hazelcast.HazelcastOperation;
import org.apache.camel.component.hazelcast.topic.HazelcastTopicEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class HazelcastTopicEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return HazelcastTopicEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return HazelcastTopicEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "reliable": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).getConfiguration().setReliable((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "hazelcastInstance": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setHazelcastInstance((HazelcastInstance)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, HazelcastInstance.class, (Object)value));
                return true;
            }
            case "hazelcastInstanceName": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setHazelcastInstanceName((String)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "defaultOperation": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setDefaultOperation((HazelcastOperation)((Object)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, HazelcastOperation.class, (Object)value)));
                return true;
            }
            case "lazyStartProducer": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setSynchronous((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "reliable": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).getConfiguration().setReliable((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "hazelcastinstance": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setHazelcastInstance((HazelcastInstance)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, HazelcastInstance.class, (Object)value));
                return true;
            }
            case "hazelcastinstancename": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setHazelcastInstanceName((String)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "defaultoperation": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setDefaultOperation((HazelcastOperation)((Object)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, HazelcastOperation.class, (Object)value)));
                return true;
            }
            case "lazystartproducer": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setSynchronous((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((HazelcastTopicEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)HazelcastTopicEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

