/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class NettyHttpProducer
extends NettyProducer {
    public NettyHttpProducer(NettyHttpEndpoint nettyEndpoint, NettyConfiguration configuration) {
        super((NettyEndpoint)nettyEndpoint, configuration);
    }

    public NettyHttpEndpoint getEndpoint() {
        return (NettyHttpEndpoint)super.getEndpoint();
    }

    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return super.process(exchange, (AsyncCallback)new NettyHttpProducerCallback(exchange, callback, this.getConfiguration()));
    }

    protected Object getRequestBody(Exchange exchange) throws Exception {
        CookieHandler cookieHandler;
        NettyHttpEndpoint endpoint = this.getEndpoint();
        String uri = NettyHttpHelper.createURL(exchange, endpoint);
        URI u = NettyHttpHelper.createURI(exchange, uri, endpoint);
        NettyHttpBinding nettyHttpBinding = endpoint.getNettyHttpBinding();
        HttpRequest request = nettyHttpBinding.toNettyRequest(exchange.getIn(), u.toString(), this.getConfiguration());
        exchange.getIn().setHeader("CamelHttpUrl", (Object)uri);
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            exchange.setProperty("CamelNettyCloseChannelWhenComplete", (Object)true);
        }
        if (this.getConfiguration().isBridgeEndpoint()) {
            exchange.getIn().removeHeader("host");
        }
        if ((cookieHandler = endpoint.getCookieHandler()) != null) {
            Map cookieHeaders = cookieHandler.loadCookies(exchange, u);
            for (Map.Entry entry : cookieHeaders.entrySet()) {
                String key = (String)entry.getKey();
                if (((List)entry.getValue()).size() <= 0) continue;
                request.headers().add(key, (Iterable)entry.getValue());
            }
        }
        return request;
    }

    private final class NettyHttpProducerCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final NettyHttpConfiguration configuration;

        private NettyHttpProducerCallback(Exchange exchange, AsyncCallback callback, NettyHttpConfiguration configuration) {
            this.exchange = exchange;
            this.callback = callback;
            this.configuration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(boolean doneSync) {
            try {
                FullHttpResponse response;
                NettyHttpMessage nettyMessage;
                if (!doneSync && (nettyMessage = (NettyHttpMessage)((Object)this.exchange.getMessage(NettyHttpMessage.class))) != null && (response = nettyMessage.getHttpResponse()) != null) {
                    response.content().retain();
                    this.exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                        public void onDone(Exchange exchange) {
                            if (response.refCnt() > 0) {
                                NettyHttpProducer.this.log.debug("Releasing Netty HttpResonse ByteBuf");
                                ReferenceCountUtil.release((Object)response);
                            }
                        }
                    });
                    String actualUrl = (String)this.exchange.getIn().getHeader("CamelHttpUrl", String.class);
                    int code = response.status() != null ? response.status().code() : -1;
                    NettyHttpProducer.this.log.debug("Http responseCode: {}", (Object)code);
                    boolean ok = NettyHttpHelper.isStatusCodeOk(code, this.configuration.getOkStatusCodeRange());
                    if (!ok && NettyHttpProducer.this.getConfiguration().isThrowExceptionOnFailure()) {
                        Exception cause = NettyHttpHelper.populateNettyHttpOperationFailedException(this.exchange, actualUrl, response, code, NettyHttpProducer.this.getConfiguration().isTransferException());
                        this.exchange.setException((Throwable)cause);
                    }
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }
    }
}

