/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty.NettyConverter;
import org.apache.camel.component.netty.http.InboundStreamHttpRequest;
import org.apache.camel.component.netty.http.InboundStreamHttpResponse;
import org.apache.camel.component.netty.http.NettyChannelBufferStreamCache;
import org.apache.camel.component.netty.http.NettyChannelBufferStreamCacheOnCompletion;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpHeaderFilterStrategy;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.component.netty.http.OutboundStreamHttpRequest;
import org.apache.camel.component.netty.http.OutboundStreamHttpResponse;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettyHttpBinding
implements NettyHttpBinding,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNettyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy = new NettyHttpHeaderFilterStrategy();

    public DefaultNettyHttpBinding() {
    }

    public DefaultNettyHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public DefaultNettyHttpBinding copy() {
        try {
            return (DefaultNettyHttpBinding)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public Message toCamelMessage(final FullHttpRequest request, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)request);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), request, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders((HttpRequest)request, (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        if (configuration.isHttpProxy() || configuration.isDisableStreamCache()) {
            answer.setBody(request.content().retain());
            exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    ReferenceCountUtil.release((Object)request.content());
                }
            });
        } else {
            NettyChannelBufferStreamCache cache = new NettyChannelBufferStreamCache(request.content());
            exchange.addOnCompletion((Synchronization)new NettyChannelBufferStreamCacheOnCompletion(cache));
            answer.setBody(cache);
        }
        return answer;
    }

    @Override
    public Message toCamelMessage(InboundStreamHttpRequest request, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)request);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), null, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(request.getHttpRequest(), (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        answer.setBody(request.getInputStream());
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateCamelHeaders(HttpRequest request, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        String http;
        LOG.trace("populateCamelHeaders: {}", (Object)request);
        headers.put("CamelHttpMethod", request.method().name());
        String s = request.uri();
        if (s.contains("?")) {
            s = StringHelper.before((String)s, (String)"?");
        }
        String string = http = configuration.isSsl() ? "https://" : "http://";
        if (!s.startsWith(http)) {
            s = configuration.getPort() != 80 ? http + configuration.getHost() + ":" + configuration.getPort() + s : http + configuration.getHost() + s;
        }
        headers.put("CamelHttpUrl", s);
        URI uri = new URI(request.uri());
        headers.put("CamelHttpUri", uri.getPath());
        headers.put("CamelHttpQuery", uri.getQuery());
        headers.put("CamelHttpRawQuery", uri.getRawQuery());
        headers.put("CamelHttpScheme", uri.getScheme());
        headers.put("CamelHttpHost", uri.getHost());
        int port = uri.getPort();
        headers.put("CamelHttpPort", port > 0 ? port : 80);
        String path = uri.getRawPath();
        if (configuration.getPath() != null) {
            String match;
            String matchPath = path.toLowerCase(Locale.US);
            String string2 = match = configuration.getPath() != null ? configuration.getPath().toLowerCase(Locale.US) : null;
            if (match != null && matchPath.startsWith(match)) {
                path = path.substring(configuration.getPath().length());
            }
        }
        headers.put("CamelHttpPath", path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP-Method {}", (Object)request.method().name());
            LOG.trace("HTTP-Uri {}", (Object)request.uri());
        }
        for (String name : request.headers().names()) {
            String value;
            if (name.toLowerCase(Locale.US).equals("content-type")) {
                name = "Content-Type";
            }
            if (name.toLowerCase(Locale.US).equals("authorization") && (value = request.headers().get(name)) != null && value.trim().startsWith("Basic")) {
                NettyHttpHelper.appendHeader(headers, "CamelHttpAuthentication", "Basic");
            }
            List values = request.headers().getAll(name);
            Iterator iterator = ObjectHelper.createIterator((Object)values, (String)",", (boolean)true);
            while (iterator.hasNext()) {
                Object extracted = iterator.next();
                String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, "UTF-8");
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)decoded, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, decoded);
            }
        }
        if (!configuration.isHttpProxy() && request.uri().contains("?")) {
            String query = StringHelper.after((String)request.uri(), (String)"?");
            Map uriParameters = URISupport.parseQuery((String)query, (boolean)false, (boolean)true);
            for (Map.Entry entry : uriParameters.entrySet()) {
                String name = (String)entry.getKey();
                Object values = entry.getValue();
                Iterator it = ObjectHelper.createIterator(values, (String)",", (boolean)true);
                while (it.hasNext()) {
                    Object extracted = it.next();
                    String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, "UTF-8");
                    LOG.trace("URI-Parameter: {}", extracted);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)decoded, exchange)) continue;
                    NettyHttpHelper.appendHeader(headers, name, decoded);
                }
            }
        }
        if (request.method().name().equals("POST") && request.headers().get("Content-Type") != null && request.headers().get("Content-Type").startsWith("application/x-www-form-urlencoded") && !configuration.isBridgeEndpoint() && !configuration.isHttpProxy() && request instanceof FullHttpRequest) {
            String body;
            String charset = "UTF-8";
            ByteBuf buffer = ((FullHttpRequest)request).content();
            try {
                body = buffer.toString(Charset.forName(charset));
            }
            finally {
                buffer.release();
            }
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)body)) {
                for (String param : body.split("&")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length == 2) {
                        String name = this.shouldUrlDecodeHeader(configuration, "", pair[0], charset);
                        String value = this.shouldUrlDecodeHeader(configuration, name, pair[1], charset);
                        if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                        NettyHttpHelper.appendHeader(headers, name, value);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
                }
            }
        }
    }

    protected String shouldUrlDecodeHeader(NettyHttpConfiguration configuration, String headerName, Object value, String charset) throws UnsupportedEncodingException {
        if ("Content-Type".equals(headerName)) {
            return value.toString();
        }
        if (configuration.isUrlDecodeHeaders()) {
            return URLDecoder.decode(value.toString(), charset);
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message toCamelMessage(FullHttpResponse response, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)response);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), null, response);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders((HttpResponse)response, (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        if (configuration.isDisableStreamCache() || configuration.isHttpProxy()) {
            answer.setBody(response.content());
        } else {
            response.retain();
            try {
                byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)response.content());
                answer.setBody(bytes);
            }
            finally {
                response.release();
            }
        }
        return answer;
    }

    @Override
    public Message toCamelMessage(InboundStreamHttpResponse response, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)response);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), null, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(response.getHttpResponse(), (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        answer.setBody(response.getInputStream());
        return answer;
    }

    @Override
    public void populateCamelHeaders(HttpResponse response, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("populateCamelHeaders: {}", (Object)response);
        headers.put("CamelHttpResponseCode", response.status().code());
        headers.put("CamelHttpResponseText", response.status().reasonPhrase());
        for (String name : response.headers().names()) {
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            List values = response.headers().getAll(name);
            Iterator it = ObjectHelper.createIterator((Object)values);
            while (it.hasNext()) {
                Object extracted = it.next();
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, extracted);
            }
        }
    }

    @Override
    public HttpResponse toNettyResponse(Message message, NettyHttpConfiguration configuration) throws Exception {
        String connection;
        NettyHttpMessage nettyHttpMessage;
        FullHttpResponse response;
        LOG.trace("toNettyResponse: {}", (Object)message);
        if (message instanceof NettyHttpMessage && (response = (nettyHttpMessage = (NettyHttpMessage)message).getHttpResponse()) != null && nettyHttpMessage.getBody() == null) {
            return response.retain();
        }
        if (message.getBody() instanceof HttpResponse) {
            return (HttpResponse)message.getBody();
        }
        Object body = message.getBody();
        Exception cause = message.getExchange().getException();
        int code = this.determineResponseCode(message.getExchange(), body);
        LOG.trace("HTTP Status Code: {}", (Object)code);
        if (cause != null && !configuration.isMuteException()) {
            if (configuration.isTransferException()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(cause);
                oos.flush();
                IOHelper.close((Closeable[])new Closeable[]{oos, bos});
                body = NettyConverter.toByteBuffer((byte[])bos.toByteArray());
                message.setHeader("Content-Type", (Object)"application/x-java-serialized-object");
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                cause.printStackTrace(pw);
                body = NettyConverter.toByteBuffer((byte[])sw.toString().getBytes());
                message.setHeader("Content-Type", (Object)"text/plain");
            }
            ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
        } else if (cause != null && configuration.isMuteException()) {
            body = NettyConverter.toByteBuffer((byte[])"Exception".getBytes());
            message.setHeader("Content-Type", (Object)"text/plain");
            ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
        }
        OutboundStreamHttpResponse response2 = null;
        if (response2 == null && body instanceof InputStream && configuration.isDisableStreamCache()) {
            response2 = new OutboundStreamHttpResponse((InputStream)body, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)code)));
            response2.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        if (response2 == null) {
            ByteBuf buffer;
            if (body instanceof ByteBuf) {
                buffer = (ByteBuf)body;
            } else {
                buffer = (ByteBuf)message.getBody(ByteBuf.class);
                if (buffer == null) {
                    byte[] data = (byte[])message.getBody(byte[].class);
                    if (data != null) {
                        buffer = NettyConverter.toByteBuffer((byte[])data);
                    } else {
                        String str = body != null ? (String)message.getMandatoryBody(String.class) : "";
                        buffer = NettyConverter.toByteBuffer((byte[])str.getBytes());
                    }
                }
            }
            if (buffer != null) {
                response2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)code), buffer);
                if (buffer.readerIndex() == buffer.writerIndex()) {
                    buffer.setIndex(0, buffer.writerIndex());
                }
                int len = buffer.readableBytes();
                response2.headers().set(HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)len);
                LOG.trace("Content-Length: {}", (Object)len);
            } else {
                response2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)code));
            }
        }
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null, (boolean)true);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                response2.headers().add(key, (Object)headerValue);
            }
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            response2.headers().set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        if ((connection = (String)message.getHeader(HttpHeaderNames.CONNECTION.toString(), String.class)) == null) {
            connection = (String)message.getExchange().getProperty(HttpHeaderNames.CONNECTION.toString(), String.class);
        }
        if (connection == null) {
            connection = configuration.isKeepAlive() ? HttpHeaderValues.KEEP_ALIVE.toString() : HttpHeaderValues.CLOSE.toString();
        }
        response2.headers().set(HttpHeaderNames.CONNECTION.toString(), (Object)connection);
        if (connection.equalsIgnoreCase(HttpHeaderValues.CLOSE.toString())) {
            message.setHeader("CamelNettyCloseChannelWhenComplete", (Object)true);
        }
        LOG.trace("Connection: {}", (Object)connection);
        return response2;
    }

    private int determineResponseCode(Exchange camelExchange, Object body) {
        int codeToUse;
        boolean failed = camelExchange.isFailed();
        int defaultCode = failed ? 500 : 200;
        Message message = camelExchange.getMessage();
        Integer currentCode = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
        int n = codeToUse = currentCode == null ? defaultCode : currentCode;
        if (codeToUse != 500 && (body == null || body instanceof String && ((String)body).trim().isEmpty())) {
            codeToUse = currentCode == null ? 204 : currentCode;
        }
        return codeToUse;
    }

    @Override
    public HttpRequest toNettyRequest(Message message, String fullUri, NettyHttpConfiguration configuration) throws Exception {
        FullHttpRequest givenRequest;
        String headerProtocolVersion;
        LOG.trace("toNettyRequest: {}", (Object)message);
        Object body = message.getBody();
        if (body instanceof HttpRequest) {
            return (HttpRequest)message.getBody();
        }
        String uriForRequest = fullUri;
        if (configuration.isUseRelativePath()) {
            String rawQuery;
            URI uri = new URI(uriForRequest);
            String rawPath = uri.getRawPath();
            if (rawPath != null) {
                uriForRequest = rawPath;
            }
            if ((rawQuery = uri.getRawQuery()) != null) {
                uriForRequest = uriForRequest + "?" + rawQuery;
            }
        }
        HttpVersion protocol = (headerProtocolVersion = (String)message.getHeader("CamelHttpProtocolVersion", String.class)) == null ? HttpVersion.HTTP_1_1 : HttpVersion.valueOf((String)headerProtocolVersion);
        String headerMethod = (String)message.getHeader("CamelHttpMethod", String.class);
        HttpMethod httpMethod = headerMethod == null ? HttpMethod.GET : HttpMethod.valueOf((String)headerMethod);
        Object request = null;
        if (message instanceof NettyHttpMessage && (givenRequest = ((NettyHttpMessage)message).getHttpRequest()) != null && givenRequest.content() == body) {
            request = givenRequest.setProtocolVersion(protocol).setMethod(httpMethod).setUri(uriForRequest);
        }
        if (request == null && body instanceof InputStream && configuration.isDisableStreamCache()) {
            request = new OutboundStreamHttpRequest((InputStream)body, new DefaultHttpRequest(protocol, httpMethod, uriForRequest));
            request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        if (request == null) {
            request = new DefaultFullHttpRequest(protocol, httpMethod, uriForRequest);
            if (body != null) {
                ByteBuf buffer;
                if (body instanceof ByteBuf) {
                    buffer = (ByteBuf)body;
                } else {
                    byte[] data;
                    buffer = (ByteBuf)message.getBody(ByteBuf.class);
                    if (buffer == null && (data = (byte[])message.getMandatoryBody(byte[].class)).length > 0) {
                        buffer = NettyConverter.toByteBuffer((byte[])data);
                    }
                }
                if (buffer != null) {
                    if (buffer.readableBytes() > 0) {
                        request = request.replace(buffer);
                        int len = buffer.readableBytes();
                        request.headers().set(HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)len);
                        LOG.trace("Content-Length: {}", (Object)len);
                    } else {
                        buffer.release();
                    }
                }
            }
        }
        HttpMethod method = NettyHttpHelper.createMethod(message, body != null);
        request.setMethod(method);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        Map skipRequestHeaders = null;
        if (configuration.isBridgeEndpoint()) {
            String queryString = (String)message.getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery((String)queryString, (boolean)false, (boolean)true);
            }
            message.getHeaders().remove("host");
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key)) continue;
            Iterator it = ObjectHelper.createIterator(value, null, (boolean)true);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                request.headers().add(key, (Object)headerValue);
            }
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            request.headers().set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        URI uRI = new URI(fullUri);
        int port = uRI.getPort();
        String hostHeader = uRI.getHost() + (port == 80 || port == -1 ? "" : ":" + uRI.getPort());
        request.headers().set(HttpHeaderNames.HOST.toString(), (Object)hostHeader);
        LOG.trace("Host: {}", (Object)hostHeader);
        String connection = (String)message.getHeader(HttpHeaderNames.CONNECTION.toString(), String.class);
        if (connection == null) {
            connection = configuration.isKeepAlive() ? HttpHeaderValues.KEEP_ALIVE.toString() : HttpHeaderValues.CLOSE.toString();
        }
        request.headers().set(HttpHeaderNames.CONNECTION.toString(), (Object)connection);
        LOG.trace("Connection: {}", (Object)connection);
        return request;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

