/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.TypeReferences;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.HttpClientHolder;
import org.apache.camel.component.salesforce.internal.client.SalesforceHttpRequest;
import org.apache.camel.component.salesforce.internal.client.SalesforceSecurityHandler;
import org.apache.camel.component.salesforce.internal.dto.RestErrors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBase
implements SalesforceSession.SalesforceSessionListener,
Service,
HttpClientHolder {
    protected static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    protected static final String APPLICATION_XML_UTF8 = "application/xml;charset=utf-8";
    private static final int DEFAULT_TERMINATION_TIMEOUT = 10;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SalesforceHttpClient httpClient;
    protected final SalesforceSession session;
    protected final String version;
    protected String accessToken;
    protected String instanceUrl;
    private Phaser inflightRequests;
    private long terminationTimeout;

    public AbstractClientBase(String version, SalesforceSession session, SalesforceHttpClient httpClient) throws SalesforceException {
        this(version, session, httpClient, 10);
    }

    AbstractClientBase(String version, SalesforceSession session, SalesforceHttpClient httpClient, int terminationTimeout) throws SalesforceException {
        this.version = version;
        this.session = session;
        this.httpClient = httpClient;
        this.terminationTimeout = terminationTimeout;
    }

    public void start() {
        this.accessToken = this.session.getAccessToken();
        if (this.accessToken == null) {
            try {
                this.accessToken = this.session.login(this.accessToken);
            }
            catch (SalesforceException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        this.instanceUrl = this.session.getInstanceUrl();
        this.session.addListener(this);
        this.inflightRequests = new Phaser(1);
    }

    public void stop() {
        if (this.inflightRequests != null) {
            this.inflightRequests.arrive();
            if (!this.inflightRequests.isTerminated()) {
                try {
                    this.inflightRequests.awaitAdvanceInterruptibly(0, this.terminationTimeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException | TimeoutException exception) {
                    // empty catch block
                }
            }
        }
        this.session.removeListener(this);
    }

    @Override
    public void onLogin(String accessToken, String instanceUrl) {
        if (!accessToken.equals(this.accessToken)) {
            this.accessToken = accessToken;
            this.instanceUrl = instanceUrl;
        }
    }

    @Override
    public void onLogout() {
    }

    protected Request getRequest(HttpMethod method, String url, Map<String, List<String>> headers) {
        return this.getRequest(method.asString(), url, headers);
    }

    protected Request getRequest(String method, String url, Map<String, List<String>> headers) {
        SalesforceHttpRequest request = (SalesforceHttpRequest)this.httpClient.newRequest(url).method(method).timeout(this.session.getTimeout(), TimeUnit.MILLISECONDS);
        request.getConversation().setAttribute(SalesforceSecurityHandler.CLIENT_ATTRIBUTE, (Object)this);
        AbstractClientBase.addHeadersTo((Request)request, headers);
        return request;
    }

    protected void doHttpRequest(final Request request, final ClientResponseCallback callback) {
        ContentProvider content = request.getContent();
        if (content instanceof InputStreamContentProvider) {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            for (ByteBuffer buffer : content) {
                buffers.add(buffer);
            }
            request.content((ContentProvider)new ByteBufferContentProvider(buffers.toArray(new ByteBuffer[buffers.size()])));
            buffers.clear();
        }
        this.inflightRequests.register();
        request.send((Response.CompleteListener)new BufferingResponseListener(this.httpClient.getMaxContentLength()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Result result) {
                try {
                    Response response = result.getResponse();
                    Map<String, String> headers = AbstractClientBase.determineHeadersFrom(response);
                    if (result.isFailed()) {
                        Throwable failure = result.getFailure();
                        if (failure instanceof SalesforceException) {
                            callback.onResponse(null, headers, (SalesforceException)((Object)failure));
                        } else {
                            String msg = String.format("Unexpected error {%s:%s} executing {%s:%s}", response.getStatus(), response.getReason(), request.getMethod(), request.getURI());
                            callback.onResponse(null, headers, new SalesforceException(msg, response.getStatus(), failure));
                        }
                    } else {
                        int status = response.getStatus();
                        SalesforceHttpRequest request2 = (SalesforceHttpRequest)((Object)((SalesforceHttpRequest)result.getRequest()).getConversation().getAttribute(SalesforceSecurityHandler.AUTHENTICATION_REQUEST_ATTRIBUTE));
                        if (status == 400 && request2 != null) {
                            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                            try {
                                AbstractClientBase.this.session.parseLoginResponse((ContentResponse)contentResponse, this.getContentAsString());
                                String msg = String.format("Unexpected Error {%s:%s} executing {%s:%s}", status, response.getReason(), request2.getMethod(), request2.getURI());
                                callback.onResponse(null, headers, new SalesforceException(msg, null));
                            }
                            catch (SalesforceException e) {
                                String msg = String.format("Error {%s:%s} executing {%s:%s}", status, response.getReason(), request2.getMethod(), request2.getURI());
                                callback.onResponse(null, headers, new SalesforceException(msg, response.getStatus(), (Throwable)((Object)e)));
                            }
                        } else if (status < 200 || status >= 300) {
                            SalesforceException exception = AbstractClientBase.this.createRestException(response, this.getContentAsInputStream());
                            callback.onResponse(this.getContentAsInputStream(), headers, exception);
                        } else {
                            callback.onResponse(this.getContentAsInputStream(), headers, null);
                        }
                    }
                }
                finally {
                    AbstractClientBase.this.inflightRequests.arriveAndDeregister();
                }
            }

            public InputStream getContentAsInputStream() {
                if (this.getContent().length == 0) {
                    return null;
                }
                return super.getContentAsInputStream();
            }
        });
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    final List<RestError> readErrorsFrom(InputStream responseContent, PayloadFormat format, ObjectMapper objectMapper, XStream xStream) throws IOException, JsonParseException, JsonMappingException {
        List<RestError> restErrors;
        if (PayloadFormat.JSON.equals((Object)format)) {
            restErrors = (List<RestError>)objectMapper.readValue(responseContent, TypeReferences.REST_ERROR_LIST_TYPE);
        } else {
            RestErrors errors = new RestErrors();
            xStream.fromXML(responseContent, (Object)errors);
            restErrors = errors.getErrors();
        }
        return restErrors;
    }

    protected abstract void setAccessToken(Request var1);

    protected abstract SalesforceException createRestException(Response var1, InputStream var2);

    static Map<String, String> determineHeadersFrom(Response response) {
        HttpFields headers = response.getHeaders();
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (HttpField header : headers) {
            String headerName = header.getName();
            if (!headerName.startsWith("Sforce")) continue;
            answer.put(headerName, header.getValue());
        }
        return answer;
    }

    private static void addHeadersTo(Request request, Map<String, List<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        HttpFields requestHeaders = request.getHeaders();
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            requestHeaders.put(header.getKey(), header.getValue());
        }
    }

    static Map<String, List<String>> determineHeaders(Exchange exchange) {
        Message inboundMessage = exchange.getIn();
        Map headers = inboundMessage.getHeaders();
        HashMap<String, List<String>> answer = new HashMap<String, List<String>>();
        for (String headerName : headers.keySet()) {
            String headerNameLowercase = headerName.toLowerCase(Locale.US);
            if (!headerNameLowercase.startsWith("sforce") && !headerNameLowercase.startsWith("x-sfdc")) continue;
            Object headerValue = inboundMessage.getHeader(headerName);
            if (headerValue instanceof String) {
                answer.put(headerName, Collections.singletonList((String)headerValue));
                continue;
            }
            if (headerValue instanceof String[]) {
                answer.put(headerName, Arrays.asList((String[])headerValue));
                continue;
            }
            if (headerValue instanceof Collection) {
                answer.put(headerName, ((Collection)headerValue).stream().map(String::valueOf).collect(Collectors.toList()));
                continue;
            }
            throw new IllegalArgumentException("Given value for header `" + headerName + "`, is not String, String array or a Collection");
        }
        return answer;
    }

    protected static interface ClientResponseCallback {
        public void onResponse(InputStream var1, Map<String, String> var2, SalesforceException var3);
    }
}

