/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.Writer;
import org.apache.camel.component.salesforce.api.dto.AnnotationFieldKeySorter;
import org.apache.camel.component.salesforce.api.utils.InstantConverter;
import org.apache.camel.component.salesforce.api.utils.LocalDateTimeConverter;
import org.apache.camel.component.salesforce.api.utils.OffsetDateTimeConverter;
import org.apache.camel.component.salesforce.api.utils.OffsetTimeConverter;
import org.apache.camel.component.salesforce.api.utils.ZonedDateTimeConverter;
import org.apache.camel.component.salesforce.internal.dto.RestChoices;
import org.apache.camel.component.salesforce.internal.dto.RestErrors;

public final class XStreamUtils {
    private static final String PERMISSIONS_PROPERTY_DEFAULT = "java.lang.*,java.util.*";
    private static final String PERMISSIONS_PROPERTY_KEY = "org.apache.camel.xstream.permissions";

    private XStreamUtils() {
    }

    public static void addDefaultPermissions(XStream xstream) {
        XStreamUtils.addPermissions(xstream, System.getProperty(PERMISSIONS_PROPERTY_KEY, PERMISSIONS_PROPERTY_DEFAULT));
    }

    public static void addPermissions(XStream xstream, String permissions) {
        for (String pterm : permissions.split(",")) {
            boolean aod;
            if ((pterm = pterm.trim()).startsWith("-")) {
                aod = false;
                pterm = pterm.substring(1);
            } else {
                aod = true;
                if (pterm.startsWith("+")) {
                    pterm = pterm.substring(1);
                }
            }
            TypePermission typePermission = null;
            if ("*".equals(pterm)) {
                typePermission = AnyTypePermission.ANY;
            } else if (pterm.indexOf(42) < 0) {
                typePermission = new ExplicitTypePermission(new String[]{pterm});
            } else if (pterm.length() > 0) {
                typePermission = new WildcardTypePermission(new String[]{pterm});
            }
            if (typePermission == null) continue;
            if (aod) {
                xstream.addPermission(typePermission);
                continue;
            }
            xstream.denyPermission(typePermission);
        }
    }

    public static XStream createXStream(Class<?> ... additionalTypes) {
        PureJavaReflectionProvider reflectionProvider = new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new AnnotationFieldKeySorter()));
        XppDriver hierarchicalStreamDriver = new XppDriver((NameCoder)new NoNameCoder()){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new CompactWriter(out, this.getNameCoder());
            }
        };
        XStream result = new XStream((ReflectionProvider)reflectionProvider, (HierarchicalStreamDriver)hierarchicalStreamDriver);
        result.aliasSystemAttribute(null, "class");
        result.ignoreUnknownElements();
        XStreamUtils.addDefaultPermissions(result);
        result.registerConverter((SingleValueConverter)new DateConverter("yyyy-MM-dd'T'HH:mm:ss.SSSZ", null), 10000);
        result.registerConverter(LocalDateTimeConverter.INSTANCE, 10000);
        result.registerConverter(OffsetDateTimeConverter.INSTANCE, 10000);
        result.registerConverter(ZonedDateTimeConverter.INSTANCE, 10000);
        result.registerConverter(InstantConverter.INSTANCE, 10000);
        result.registerConverter(OffsetTimeConverter.INSTANCE, 10000);
        result.setMarshallingStrategy((MarshallingStrategy)new TreeMarshallingStrategy());
        result.processAnnotations(RestErrors.class);
        result.processAnnotations(RestChoices.class);
        result.processAnnotations((Class[])additionalTypes);
        return result;
    }
}

