/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.approval;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.salesforce.api.dto.RestError;

@XStreamAlias(value="ProcessApprovalResult")
@JsonDeserialize(using=ApprovalResultDeserializer.class)
public final class ApprovalResult
implements Serializable,
Iterable<Result> {
    private static final long serialVersionUID = 1L;
    @XStreamImplicit(itemFieldName="ProcessApprovalResult")
    private final List<Result> results;

    public ApprovalResult() {
        this(new ArrayList<Result>());
    }

    private ApprovalResult(List<Result> results) {
        this.results = results;
    }

    @Override
    public Iterator<Result> iterator() {
        return this.results.listIterator();
    }

    public int size() {
        return this.results.size();
    }

    @XStreamAlias(value="ProcessApprovalResult")
    public static final class Result
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamImplicit(itemFieldName="actorIds")
        private final List<String> actorIds;
        private final String entityId;
        @XStreamImplicit(itemFieldName="errors")
        private final List<RestError> errors;
        private final String instanceId;
        private final String instanceStatus;
        @XStreamImplicit(itemFieldName="newWorkitemIds")
        private final List<String> newWorkitemIds;
        private final boolean success;

        @JsonCreator
        Result(@JsonProperty(value="actorIds") List<String> actorIds, @JsonProperty(value="entityId") String entityId, @JsonProperty(value="errors") List<RestError> errors, @JsonProperty(value="instanceId") String instanceId, @JsonProperty(value="instanceStatus") String instanceStatus, @JsonProperty(value="newWorkitemIds") List<String> newWorkitemIds, @JsonProperty(value="success") boolean success) {
            this.actorIds = actorIds;
            this.entityId = entityId;
            this.errors = errors;
            this.instanceId = instanceId;
            this.instanceStatus = instanceStatus;
            this.newWorkitemIds = newWorkitemIds;
            this.success = success;
        }

        public List<String> getActorIds() {
            return this.actorIds;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public List<RestError> getErrors() {
            return this.errors;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getInstanceStatus() {
            return this.instanceStatus;
        }

        public List<String> getNewWorkitemIds() {
            return this.newWorkitemIds;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    public static final class ApprovalResultDeserializer
    extends JsonDeserializer {
        private static final TypeReference<List<Result>> RESULTS_TYPE = new TypeReference<List<Result>>(){};

        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            List results = (List)parser.readValueAs(RESULTS_TYPE);
            return new ApprovalResult(results);
        }
    }
}

