/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceConsumer;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceProducer;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.streaming.SubscriptionHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.SynchronousDelegateProducer;

@UriEndpoint(firstVersion="2.12.0", scheme="salesforce", title="Salesforce", syntax="salesforce:operationName:topicName", label="api,cloud,crm")
public class SalesforceEndpoint
extends DefaultEndpoint {
    @UriPath(label="producer", description="The operation to use", enums="getVersions,getResources,getGlobalObjects,getBasicInfo,getDescription,getSObject,createSObject,updateSObject,deleteSObject,getSObjectWithId,upsertSObject,deleteSObjectWithId,getBlobField,query,queryMore,queryAll,search,apexCall,recent,createJob,getJob,closeJob,abortJob,createBatch,getBatch,getAllBatches,getRequest,getResults,createBatchQuery,getQueryResultIds,getQueryResult,getRecentReports,getReportDescription,executeSyncReport,executeAsyncReport,getReportInstances,getReportResults,limits,approval,approvals,composite-tree,composite-batch,composite")
    private final OperationName operationName;
    @UriPath(label="consumer", description="The name of the topic/channel to use")
    private final String topicName;
    @UriParam
    private final SalesforceEndpointConfig configuration;
    @UriParam(label="consumer", description="The replayId value to use when subscribing")
    private Long replayId;

    public SalesforceEndpoint(String uri, SalesforceComponent salesforceComponent, SalesforceEndpointConfig configuration, OperationName operationName, String topicName) {
        super(uri, (Component)salesforceComponent);
        this.configuration = configuration;
        this.operationName = operationName;
        this.topicName = topicName;
    }

    public Producer createProducer() throws Exception {
        if (this.operationName == null) {
            throw new IllegalArgumentException(String.format("Invalid Operation %s", this.topicName));
        }
        SalesforceProducer producer = new SalesforceProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)producer);
        }
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.topicName == null) {
            throw new IllegalArgumentException(String.format("Invalid topic name %s, matches a producer operation name", this.operationName.value()));
        }
        SubscriptionHelper subscriptionHelper = this.getComponent().getSubscriptionHelper();
        SalesforceConsumer consumer = new SalesforceConsumer(this, processor, subscriptionHelper);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public SalesforceComponent getComponent() {
        return (SalesforceComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public SalesforceEndpointConfig getConfiguration() {
        return this.configuration;
    }

    public OperationName getOperationName() {
        return this.operationName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setReplayId(Long replayId) {
        this.replayId = replayId;
    }

    public Long getReplayId() {
        return this.replayId;
    }

    protected void doStart() throws Exception {
        try {
            super.doStart();
        }
        finally {
            SalesforceHttpClient httpClient = this.getConfiguration().getHttpClient();
            if (httpClient != null && this.getComponent().getConfig().getHttpClient() != httpClient) {
                String endpointUri = this.getEndpointUri();
                this.log.debug("Starting http client for {} ...", (Object)endpointUri);
                httpClient.start();
                this.log.debug("Started http client for {}", (Object)endpointUri);
            }
        }
    }

    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            SalesforceHttpClient httpClient = this.getConfiguration().getHttpClient();
            if (httpClient != null && this.getComponent().getConfig().getHttpClient() != httpClient) {
                String endpointUri = this.getEndpointUri();
                this.log.debug("Stopping http client for {} ...", (Object)endpointUri);
                httpClient.stop();
                this.log.debug("Stopped http client for {}", (Object)endpointUri);
            }
        }
    }
}

