/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics.event.notifier.exchange;

import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsExchangeRecorder;
import org.apache.camel.component.microprofile.metrics.event.notifier.AbstractMicroProfileMetricsEventNotifier;
import org.apache.camel.component.microprofile.metrics.event.notifier.exchange.MicroProfileMetricsExchangeEventNotifierNamingStrategy;
import org.apache.camel.spi.CamelEvent;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class MicroProfileMetricsExchangeEventNotifier
extends AbstractMicroProfileMetricsEventNotifier<CamelEvent.ExchangeEvent> {
    private Predicate<Exchange> ignoreExchanges = exchange -> false;
    private MicroProfileMetricsExchangeEventNotifierNamingStrategy namingStrategy = MicroProfileMetricsExchangeEventNotifierNamingStrategy.DEFAULT;
    private MicroProfileMetricsExchangeRecorder exchangeRecorder;

    public MicroProfileMetricsExchangeEventNotifier() {
        super(CamelEvent.ExchangeEvent.class);
    }

    public Predicate<Exchange> getIgnoreExchanges() {
        return this.ignoreExchanges;
    }

    public MicroProfileMetricsExchangeEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicroProfileMetricsExchangeEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        CamelContext camelContext = this.getCamelContext();
        MetricRegistry metricRegistry = this.getMetricRegistry();
        Tag tag = new Tag("camelContext", camelContext.getName());
        this.exchangeRecorder = new MicroProfileMetricsExchangeRecorder(metricRegistry, "camel.context", tag);
    }

    public void notify(CamelEvent event) throws Exception {
        if (!this.getIgnoreExchanges().test(((CamelEvent.ExchangeEvent)event).getExchange())) {
            if (event instanceof CamelEvent.ExchangeSentEvent) {
                this.handleSentEvent((CamelEvent.ExchangeSentEvent)event);
            } else if (event instanceof CamelEvent.ExchangeCreatedEvent) {
                this.handleCreatedEvent((CamelEvent.ExchangeCreatedEvent)event);
            } else if (event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent) {
                this.handleDoneEvent((CamelEvent.ExchangeEvent)event);
            }
        }
    }

    protected void handleCreatedEvent(CamelEvent.ExchangeCreatedEvent createdEvent) {
        String name = this.namingStrategy.getName(createdEvent.getExchange(), createdEvent.getExchange().getFromEndpoint());
        Tag[] tags = this.namingStrategy.getTags((CamelEvent.ExchangeEvent)createdEvent, createdEvent.getExchange().getFromEndpoint());
        Timer timer = this.getMetricRegistry().timer(name + ".processing", tags);
        createdEvent.getExchange().setProperty("eventTimer:" + name, (Object)timer);
        createdEvent.getExchange().setProperty("eventTimerContext:" + name, (Object)timer.time());
        this.exchangeRecorder.recordExchangeBegin();
    }

    protected void handleSentEvent(CamelEvent.ExchangeSentEvent sentEvent) {
        String name = this.namingStrategy.getName(sentEvent.getExchange(), sentEvent.getEndpoint());
        Timer timer = (Timer)sentEvent.getExchange().getProperty("eventTimer:" + name, Timer.class);
        if (timer == null) {
            Tag[] tags = this.namingStrategy.getTags((CamelEvent.ExchangeEvent)sentEvent, sentEvent.getEndpoint());
            timer = this.getMetricRegistry().timer(name + ".processing", tags);
            sentEvent.getExchange().setProperty("eventTimer:" + name, (Object)timer);
        }
        timer.update(sentEvent.getTimeTaken(), TimeUnit.MILLISECONDS);
    }

    protected void handleDoneEvent(CamelEvent.ExchangeEvent doneEvent) {
        Exchange exchange = doneEvent.getExchange();
        String name = this.namingStrategy.getName(exchange, exchange.getFromEndpoint());
        exchange.removeProperty("eventTimer:" + name);
        Timer.Context context = (Timer.Context)exchange.removeProperty("eventTimerContext:" + name);
        if (context != null) {
            context.stop();
        }
        this.exchangeRecorder.recordExchangeComplete(exchange);
    }
}

