/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.List;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.microprofile.metrics.AbstractMicroProfileMetricsProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsMeteredProducer
extends AbstractMicroProfileMetricsProducer<Meter> {
    public MicroProfileMetricsMeteredProducer(MicroProfileMetricsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MicroProfileMetricsEndpoint endpoint, Meter meter) {
        Long value = this.getLongHeader(exchange.getIn(), "CamelMicroProfileMetricsMeterMark", endpoint.getMark());
        if (value != null) {
            meter.mark(value.longValue());
        } else {
            meter.mark();
        }
    }

    @Override
    protected Function<MetricRegistry, Meter> registerMetric(Metadata metadata, List<Tag> tags) {
        return metricRegistry -> metricRegistry.meter(metadata, tags.toArray(new Tag[0]));
    }
}

