/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import org.apache.camel.Exchange;
import org.apache.camel.component.microprofile.metrics.gauge.AtomicIntegerGauge;
import org.apache.camel.support.ExchangeHelper;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsExchangeRecorder {
    private Counter exchangesCompleted;
    private Counter exchangesFailed;
    private Counter exchangesTotal;
    private AtomicIntegerGauge exchangesInflight;
    private Counter externalRedeliveries;
    private Counter failuresHandled;

    public MicroProfileMetricsExchangeRecorder(MetricRegistry metricRegistry, String metricName, Tag ... tags) {
        this.configureMetrics(metricRegistry, metricName, tags);
    }

    public void recordExchangeBegin() {
        this.exchangesInflight.increment();
    }

    public void recordExchangeComplete(Exchange exchange) {
        this.exchangesTotal.inc();
        this.exchangesInflight.decrement();
        if (!exchange.isFailed()) {
            this.exchangesCompleted.inc();
            if (ExchangeHelper.isFailureHandled((Exchange)exchange)) {
                this.failuresHandled.inc();
            }
            if (exchange.isExternalRedelivered() != null && exchange.isExternalRedelivered().booleanValue()) {
                this.externalRedeliveries.inc();
            }
        } else {
            this.exchangesFailed.inc();
        }
    }

    protected void configureMetrics(MetricRegistry metricRegistry, String metricName, Tag ... tags) {
        Metadata exchangesCompletedMetadata = new MetadataBuilder().withName(metricName + ".exchanges.completed.total").withDisplayName("Exchanges completed").withDescription("The total number of completed exchanges for a route or Camel Context").withType(MetricType.COUNTER).build();
        this.exchangesCompleted = metricRegistry.counter(exchangesCompletedMetadata, tags);
        Metadata exchangesFailedMetadata = new MetadataBuilder().withName(metricName + ".exchanges.failed.total").withDisplayName("Exchanges failed").withDescription("The total number of failed exchanges for a route or Camel Context").withType(MetricType.COUNTER).build();
        this.exchangesFailed = metricRegistry.counter(exchangesFailedMetadata, tags);
        Metadata exchangesTotalMetadata = new MetadataBuilder().withName(metricName + ".exchanges.total").withDisplayName("Exchanges total").withDescription("The total number of exchanges for a route or Camel Context").withType(MetricType.COUNTER).build();
        this.exchangesTotal = metricRegistry.counter(exchangesTotalMetadata, tags);
        Metadata exchangesInflightMetadata = new MetadataBuilder().withName(metricName + ".exchanges.inflight.count").withDisplayName("Exchanges inflight").withDescription("The count of exchanges inflight for a route or Camel Context").withType(MetricType.GAUGE).build();
        this.exchangesInflight = (AtomicIntegerGauge)metricRegistry.register(exchangesInflightMetadata, (Metric)new AtomicIntegerGauge(), tags);
        Metadata externalRedeliveriesMetadata = new MetadataBuilder().withName(metricName + ".externalRedeliveries.total").withDisplayName("Exchanges external redeliveries").withDescription("The total number of external redeliveries for a route or Camel Context").withType(MetricType.COUNTER).build();
        this.externalRedeliveries = metricRegistry.counter(externalRedeliveriesMetadata, tags);
        Metadata failuresHandledMetadata = new MetadataBuilder().withName(metricName + ".failuresHandled.total").withDisplayName("Exchanges failures handled").withDescription("The total number of failures handled for a route or Camel Context").withType(MetricType.COUNTER).build();
        this.failuresHandled = metricRegistry.counter(failuresHandledMetadata, tags);
    }
}

